// pages/prescription/details/details.js
const Api = require('../../utils/api.js');
Page({
	/**
	 * 页面的初始数据
	 */
	data: {
		list:[],
		id:'',
		iphonex:false,
		inquiry_id:''
	},

	/**
	 * 生命周期函数--监听页面加载
	 */
	onLoad: function (options) {	
		var that = this
		var url = Api.HOST + 'wechatIteration.php?s=/Prescription/detailPrescription';
		that.checkModal();
		//console.log(url)
		var data = {
			id:options.id,
			inquiry_id:options.orderId
		};
		Api.fetchPost(url, data, (err, res) => {
			console.log(res)
			if(res.code==1){
				that.setData({
					list: res.data,
					id: data.id,
					inquiry_id:options.orderId
				})
			}else{
				wx.showModal({
					title: '提示',
					content: res.msg,
					showCancel: false,
					success (res) {
						if (res.confirm) {
							wx.navigateBack({
								complete: (res) => {
									delta: 1
								},
							})
						} 
					}
				})
			} 
			
		})
	},
	putDemand(){
		var that = this
				wx.navigateTo({
					url: '/packageA/drugOrderInfo/drugOrderInfo?id='+that.data.id+'&inquiry_id='+that.data.inquiry_id,
				})
			
	},
	///查看订单
	checkorder:function(){
		var that = this
		// wx.navigateTo({
		// 	url: '/pages/prescription/orderInfo/orderInfo?id='+that.data.id+'&inquiry_id='+that.data.inquiry_id,
		// })
		wx.navigateTo({
			url: '/pages/drugOrder/drugOrder?status=' + that.data.list.drug_order_status,
		})
	},
	/**
	 * 生命周期函数--监听页面初次渲染完成
	 */
	onReady: function () {

	},

	/**
	 * 生命周期函数--监听页面显示
	 */
	onShow: function () {

	},

	/**
	 * 生命周期函数--监听页面隐藏
	 */
	onHide: function () {

	},

	/**
	 * 生命周期函数--监听页面卸载
	 */
	onUnload: function () {

	},

	/**
	 * 页面相关事件处理函数--监听用户下拉动作
	 */
	onPullDownRefresh: function () {

	},

	/**
	 * 页面上拉触底事件的处理函数
	 */
	onReachBottom: function () {

	},

	/**
	 * 用户点击右上角分享
	 */
	onShareAppMessage: function () {

	},
	  	//判断是否是iPhonex
			checkModal:function() {
				let that = this;
				wx.getSystemInfo({
					success: (res) => {
						// iPhone X   iPhone XR  iPhone XS Max     iPhone XS
						if (/^iPhone X.*/i.test(res.model) || /^iPhone XR.*/i.test(res.model) || /^iPhone XS.*/i.test(res.model)||/^iPhone 11*/i.test(res.model)||/^iPhone 11 Pro Max*/i.test(res.model)) {
							that.setData({
								iPhoneX: true,
							})
						} else {				
							that.setData({
								iPhoneX: false,
							})
						}
					}
				});
			},
})