var Service = require('../../utils/service.js');
var Util = require('../../utils/util.js');
Page({

  /**
   * 页面的初始数据
   */
  data: {
    ishow: false,
    type: 1,
    deleteModal: true,
    start_time: '',
    userid: '',
    t_userInfo: {},
    activeNum: 2,
    serviceData: {
      16: [{
          con: '1. 通过本服务的检测，您可以了解您的心理健康状况或者心理特征、性格特点等；'
        }, {
          con: '2. 采用的是包括解放军301医院、北京大学第一医院、清华大学长庚医院、武汉大学人民医院、中国医科大学第一附属医院等全国500余家大型医疗机构临床使用的检测工具，确保检测的准确性；'
        },
        {
          con: '3. 本服务价格包含对报告结果的解读；'
        },
        {
          con: '4. 由于医生通过空余时间为您服务，服务支付后，医生未在24小时内接诊，系统自动退费。'
        }
      ],
      17: [{
          con: '1. 通过本服务，您可以针对自身的心理症状，与临床执业医师通过图文、隐私电话、视频等方式进行沟通；'
        },
        {
          con: '2. 医生利用空余时间为您服务，该订单在24小时内完成，24小时后服务关闭；'
        },
        {
          con: '3. 在以上所有服务过程中，对复诊患者均可开处方、购药；'
        },
        {
          con: '4. 医生未在24小时内接单，系统自动退费，您也可自己选择取消订单。'
        }
      ],
      20: [{
          con: '1. 本服务只针对复诊患者进行简单的疾病问询和处方调整；'
        },
        {
          con: '2.开具处方后，药品通过快递直接配送到家；'
        },
        {
          con: '3.  由于医生通过空余时间为您服务，服务支付后，医生未在24小时内接诊，系统自动退费。'
        }
      ],
      18: [{
          con: '1.通过本服务，您可以选择一位心理咨询师，针对您遇到的问题，帮您解惑，或者缓解您的情绪压力。我们将竭诚为您提供中国最高水准的心理咨询服务。平台汇聚了众多拥有正规资质、水平高超的心理咨询专家，他们分别拥有自己最为擅长的咨询领域；'
        },
        // {
        //   con: '2. 您可以通过预备咨询的方式，自己选择一位符合您需要的咨询师。在预备咨询过程中，咨询师也会评估您的问题他是否能够胜任，这是一个双向选择的过程。预备咨询确定咨询师之后，您便可以开启正式的心理咨询之旅；'
        // },
        {
          con: '2. 平台入驻有众多的临床心理科医生，从您的健康考虑，如果在心理咨询过程中，发现可能涉及到的心理疾病问题，在得到您的同意后，心理咨询师可能将您的情况转介到临床心理科医生；'
        }, {
          con: '3. 和问诊不同，心理咨询需要心理医生用连续的50分钟时间为您提供服务，在您购买服务后，可与心理医生协商时间；'
        },
        {
          con: '4. 医生未在24小时内接单，系统自动退费，您也可自己选择取消订单。'
        }
      ],
      19: [{
          con: '1. 本服务以倾诉为主，当您情绪低落、需要帮助时，您可以通过电话倾诉，及时得到心理支持，释放压力；'
        },
        {
          con: '2. 平台采用第三方隐私通话系统，不显示真实号码，确保个人信息和倾诉内容绝对安全，让您完全做回自己；'
        },
        {
          con: '3. 服务支付后，医生未在24小时内接诊，系统自动退费，您也可自己选择取消订单。'
        }
      ],
      22: [{
          con: '1. 心理健康最好的管理办法是“早发现、早干预、早治疗”，防止问题严重，因此，私人医生的长期服务可以对您的健康进行连续管理，守护您的心理健康；'
        },
        {
          con: '2. 精神心理疾病发作后两年内是复发率高发时期（数据显示首年复发率约50%，第二年复发率约80%），每次复发均对患者造成极大的创伤，也为日后的治疗形成极大的障碍。如果康复管理得当，两年内不复发，患者恢复到病前状态，重返社会的可能性大大增加。因此，发作后两年是治疗的“关键时期”，尤为重要；'
        },
        {
          con: '3. 由专属私人医生对您的健康制定个性化的计划，并进行连续管理，目的是预防心理疾病发生、促进疾病康复和降低疾病复发率；'
        },
        {
          con: '4. 由临床执业医师通过图文、隐私电话、视频等方式与您沟通；医生可根据情况给予线下面诊或住院指导帮助；'
        },
        {
          con: '5. 医生利用空余时间为您服务，服务过程中，对复诊患者均可开处方、购药。'
        },
      ]
    },
    t_openid: '',
    t_unitid: '',
    unionid: '',
    voice_price: '',
    image_price: '',
    iPhoneX: false,
    buy_type: '',
    name: '',
    inforList: [
      { url: "url", title: "出诊安排：国家关于增值税调整的通知" },
      { url: "url", title: "出诊安排：清得快二线城市通知" },
      { url: "url", title: "出诊安排：纳尼，要回去毕业答辩了？" }
    ]
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    var that = this;
    console.log("options",options);
    that.checkModal();
    that.setData({
      options: options,
      t_openid: options.t_openid,
      t_unitid: options.t_unitid,
      t_unionid: options.t_unionid
    })
    var data = {};
    data.unitid = options.t_unitid;
    //获取医生服务信息
    Service.getDoctorDetail(data).then((res) => {
      if (res.code == 1) {
        let titleArr=['','住院医师','主治医师','副主任医师','主任医师','国家心理治疗师','国家二级心理咨询师','国家三级心理咨询师'];
        let title=titleArr[res.data.title];
        that.setData({
          t_userInfo: res.data,
          't_userInfo.title': title,
          buyprice: res.data.service[16].price,
          buy_type: res.data.service[16].id,
        })
        //判断服务选中与按钮显示
        if (Util.isEmpty(options.counsel)) {
          //判断选中服务模块与购买服务按钮显示 add 刘权 dateTime 2020-3-21
          that.optFor(res.data.service);
        } else {
          //判断重复购买
          that.repetition(res.data.service, options.counsel);
        }
      }
    })
  },
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    //用户信息
    var that = this;
    that.login = that.selectComponent("#login");
    wx.login({
      success: function (msg) {
        Service.getOpenId(msg.code).then((res) => {
          wx.setStorageSync('user', res)
          return Service.getUserData(res.openid)
        }).then((res) => {
          if (Util.isEmpty(res.unionid)) {
            that.login.showLogin();
          } else {
            wx.setStorageSync('data', res)
            that.setData({
              userInfo: res,
            })
          }
        })
      }
    })
  },
  /**
   * 生命周期函数--监听转发
   */
  onShareAppMessage: function (res) {
    var that = this;
    return {
      title: this.data.t_userInfo.name + '医生的个人主页',
      path: '/pages/docuterInfo/docuterInfo?t_unionid=' + that.data.options.t_unionid + '&t_unitid=' + that.data.options.t_unitid + '&t_openid=' + that.data.options.t_openid,
    }
  },
  selected(e) {
    let item = e.currentTarget.dataset.item;
    if (item.isopen == 0) {
      this.setData({
        ishow: false,
      })
    } else {
      this.setData({
        ishow: true,
      })
    }
    this.setData({
      type: item.id,
    })
    this.setData({
      buy_type: item.id,
      buyprice: item.price,
      name: item.name,
      activeNum: 1,
    })
  },
  select(e) {
    let num = e.currentTarget.dataset.num;
    let price = e.currentTarget.dataset.price;
    this.setData({
      activeNum: num,
      buyprice: price
    })
  },
  goIntro() {
    wx.showLoading();
    var that = this;
    wx.navigateTo({
      url: '/pages/doctorIntro/doctorIntro?t_unionid=' + that.data.t_unionid + '&t_unitid=' + that.data.t_unitid + '&t_openid=' + that.data.t_openid,
    })
    wx.hideLoading();
  },
  //支付
  applyPay: function (e) {
    wx.showLoading({
      title: '正在生成',
      mask: true
    })
    let that = this;
    var user = wx.getStorageSync('user');
    var alldata = wx.getStorageSync('data');
    if (Util.isEmpty(alldata.unionid) || Util.isEmpty(user.openid)) {
      wx.hideLoading();
      that.login.showLogin();
      return;
    } else {
      if (that.data.buy_type == 18 || e.currentTarget.dataset.bid == 'abc') {
        that.setData({
          buyprice: e.currentTarget.dataset.price,
          buy_type: e.currentTarget.dataset.id,
          name: e.currentTarget.dataset.name
        })
      }
      let PayRecord_datas = {
        openid: user.openid,
        gold: that.data.buyprice,
        usename: that.data.buy_type,
        unitid: that.data.t_userInfo.unitid,
        type: "2" //量表1 服务2 药方3
      }
      console.log("PayRecord_datas",PayRecord_datas)
      var ServicePay_datas = {};
      let payRecord;
      if(that.data.buy_type=="20"){
        payRecord=Service.GZPayRecord(PayRecord_datas);
      }else{
        payRecord=Service.payRecord(PayRecord_datas);
      }
      payRecord.then((res) => {
        console.log("payRecord",res)
        that.data.payRecord = res;
        ServicePay_datas = {
          unitid: that.data.t_unitid,
          counsel: that.data.buy_type,
          patient_unionid: alldata.unionid,
          consultant_unionid: that.data.t_userInfo.unionid,
          put_trade_no: res.info.dealarr.out_trade_no,
          money: that.data.buyprice,
        }
        if (that.data.buy_type == "22") {
          ServicePay_datas.type = that.data.activeNum;
        } else if (that.data.buy_type == "17") {
          ServicePay_datas.type = '2';
        } else {
          ServicePay_datas.type = '';
        }
        var conductdata = {
          unitid: that.data.t_unitid,
          counsel: that.data.buy_type,
          patient_unionid: alldata.unionid
        };
        return Service.isInquiry(conductdata);
      }).then((conductRes) => {
        console.log("isInquiry",conductRes)
        var payRecord = that.data.payRecord;
        if (conductRes.code == 1) {
          //edit 刘权 dateTime 2020-3-23
          wx.setStorageSync('t_userInfo', that.data.t_userInfo)
          wx.setStorageSync('orderInfo', payRecord.info.parameter)
          wx.hideLoading();
          wx.navigateTo({
            url: '/packageA/buyService/buyService?ServicePay_datas=' + JSON.stringify(ServicePay_datas) + '&orderTime=' + Util.timeMethod(payRecord.info.parameter.timeStamp) + '&name=' + that.data.name,
          })
          wx.hideLoading();
        } else {
          let t_unionid = that.data.t_userInfo.unionid;
          wx.navigateTo({
            url: '/packageA/chat/chat?t_unionid=' + t_unionid + '&orderId=' + conductRes.data+'&groupID='+conductRes.chat_id,
          })
          wx.hideLoading();
        }
      }).catch((err)=>{
        wx.hideLoading();
        console.error('err',err);
      });
    }
  },
  //判断选中服务模块与购买服务按钮显示 add 刘权 dateTime 2020-3-21
  optFor: function (serviceList) {
    var that = this;
    var isopen = false;
    for (var item in serviceList) {
      if (serviceList[item].is_open == '1' && !isopen) {
        isopen = true;
        switch (serviceList[item].id) {
          case "16":
          case "17":
          case "18":
          case "19":
          case "20":
            that.setData({
              ishow: true,
              buy_type: serviceList[item].id,
              buyprice: serviceList[item].price,
              type: serviceList[item].id,
              name: serviceList[item].name
            })
            return;
          case "22":
            that.setData({
              ishow: true,
              buy_type: serviceList[item].id,
              buyprice: serviceList[item].price,
              type: serviceList[item].id,
              name: serviceList[item].name,
              activeNum: 1,
            })
            return;
        }
      } else {
        if (!isopen) {
          that.setData({
            ishow: false
          })
        }
      }
    }
    // serviceList.forEach(function (item, index) {

    // })
  },
  //判断重复购买 add 刘权 dateTime 2020-4-16
  repetition: function (serviceList, counsel) {
    console.log(counsel)
    var that = this;
    var isopen = false;
    for (var item in serviceList) {
      if (serviceList[item].id == counsel && !isopen) {
        if (serviceList[item].is_open != '1') {
          that.optFor(serviceList)
          return;
        }
        isopen = true;
        switch (counsel) {
          case "16":
          case "17":
          case "18":
          case "19":
          case "20":
            that.setData({
              ishow: true,
              buy_type: counsel,
              buyprice: serviceList[item].price,
              type: counsel,
              name: serviceList[item].name
            })
            return;
          case "22":
            that.setData({
              ishow: true,
              buy_type: counsel,
              buyprice: serviceList[item].price,
              type: counsel,
              name: serviceList[item].name,
              activeNum: 1,
            })
            return;
        }
      } else {
        if (!isopen) {
          that.setData({
            ishow: false
          })
        }
      }
    }
    // serviceList.forEach(function (item, index) {

    // })
  },
  //判断是否是iPhonex
  checkModal: function () {
    let that = this;
    wx.getSystemInfo({
      success: (res) => {
        // iPhone X   iPhone XR  iPhone XS Max     iPhone XS iPhone 11 Pro Max iPhone 11 
        if (/^iPhone X.*/i.test(res.model) || /^iPhone XR.*/i.test(res.model) || /^iPhone XS.*/i.test(res.model) || /^iPhone 11*/i.test(res.model) || /^iPhone 11 Pro Max*/i.test(res.model)) {
          that.setData({
            iPhoneX: true,
          })
        } else {
          that.setData({
            iPhoneX: false,
          })
        }
      }
    });
  },

  //登陆后组件回调方法刷新当前页面
  _refreshEvent() {
    console.log("刷新");
    this.onShow();
  },
  /**
   * 图片加载失败函数
   * @param {*} e 
   */
  binderrorimg(e) {
    let up = "t_userInfo.image";
    this.setData({
      [up]: '/images/doctor_img.png'
    })
  },
})