const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');

Page({
  data: {
    userInfo: '',
    reportRedD: false, //报告红点展示
    reportRedNum: 0, //未作报告数量
    disabled:true,//防止重复点击
    version:'3.1.2',
    isShow:false,
    showClose:true,
  },
  onLoad: function () {
    wx.setNavigationBarTitle({
      title: '个人中心'
    })
  },
  onShow: function () {
    var that = this;
    wx.login({
      success: function (msg) {
        Service.getOpenId(msg.code).then((res) => {
          wx.setStorageSync('user', res)
          return Service.getUserData(res.openid)
        }).then((res) => {
          wx.setStorageSync('data', res) 
          that.setData({
            userInfo:res,
            unionid: res.unionid || '',
            nickname: res.nickname || res.name || 0,
            headimgurl: res.headimgurl || '/images/head-img.png',
            isShow:true
          })
          // that.resultNot(res.openid)
        })
      }
    })
  },
  onReady: function () {
    //获得modal组件
    this.modal = this.selectComponent("#modal");
    this.login = this.selectComponent("#login");
    this.answer = this.selectComponent("#answer");
  },
    /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {
    return {
      title: '个人中心',
      path: '/pages/my/my',
    }
  },
  //菜单栏红点提示
  resultNot(openid) {
  //未做量表提醒
  console.log("resultNot")
    var data = {
      openid: openid
    }
    Service.getNotResult(data).then((res) => {
      if (res[0].length > 0) {
        this.setData({
          reportRedD: true,
        })
        this.structureDataUser(res[0]);
        wx.showTabBarRedDot({
          index: 2
        })
      } else {
        this.setData({
          reportRedD: false,
          reportRedNum: 0
        })
        wx.hideTabBarRedDot({
          index: 2
        })
      }
    })
  },
  //计算未做量表数量
  structureDataUser(e) {
    let that = this;
    let reportRedNum = 0;
    for (let j in e) {
      if (e[j].measure_id_z != '') {
        var len = e[j].measure_id_z.split(',').length;
        reportRedNum = reportRedNum + len;
      }
    }
    that.setData({
      reportRedNum: reportRedNum,
    })
  },
  /**跳转页面 */
  goToURL:Util.debouce(function(e){
    var that = this;
    if (that.data.confirm) {
      return;
    }
    that.data.confirm = true
    var data=wx.getStorageSync('data') 
    if (Util.isEmpty(data.unionid)) {
      that.login.showLogin();
    } else {
      wx.navigateTo({
        url:e.currentTarget.dataset.src,
      })
    }
    that.data.confirm=false;
  },1000,true),
// 我的报告
myReport:Util.debouce(function() {
  var that=this;
  if (that.data.confirm) {
    return;
  }
  that.data.confirm = true
  var data=wx.getStorageSync('data') 
  if (Util.isEmpty(data.unionid)) {
    that.login.showLogin();
  } else {
    wx.navigateTo({
      url: '/packageB/myReport/myReport?type=0',
    })
  }
  that.data.confirm=false;
},1000,true),
getUserInfo(){
  this.login.showLogin();
},
//客服电话
dial(e) {
  let tel = e.currentTarget.dataset.tel;
  wx.makePhoneCall({
    phoneNumber: tel,
  })
},

//设置推送
setPush: function () {
  wx.openSetting()
},
//登陆后组件回调方法刷新当前页面
_refreshEvent() {
    console.log("刷新");
    this.onShow();
  },
    /**
   * 图片加载失败函数
   * @param {any} e 
   */
  binderrorimg(){
      this.setData({
        headimgurl:'/images/head-img.png'
      })
  },
})