const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');
Page({

  /**
   * 页面的初始数据
   */
  data: {
    noRecord: {
      winH: null,
    },
    rechargeList: [],
    showview: false,
    startX: 0, //开始坐标
    startY: 0
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    wx.getSystemInfo({
      success: (res) => {
        this.setData({
          ['noRecord.winH']: res.windowHeight
        })
      }
    })
  },
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    this.getServerList();
  },
  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {
    this.getServerList();
  },

  //删除
  delBtn: function (e) {
    console.log(e)
    var that = this
   Service.delService(e.currentTarget.dataset.id).then((res)=>{
      if (res.code == 1) {
        wx.showToast({
          title: '删除成功',
          mask: true,
          icon: 'success'
        })
        that.getServerList();
      }
    })

  },
  //获取服务列表
  getServerList() {
    //修改API路径
    var that = this;
    var data = {
      patient_unionid: wx.getStorageSync('data').unionid
    };
    Service.getServiceList(data).then((res) => {
      if (res.code == 1) {
        that.setData({
          rechargeList: res.data,
          showview: true
        })
        wx.stopPullDownRefresh();
      }else{
        that.setData({
          rechargeList: [],
          showview: true
        })
        wx.showToast({
          title: res.msg,
          icon:'none',
          duration:3000
        })
        wx.stopPullDownRefresh();
      }
    })
  },
  touchE: function (e) {
    // console.log(e);
    var that = this
    if (e.changedTouches.length == 1) {
      //手指移动结束后触摸点位置的X坐标
      var endX = e.changedTouches[0].clientX;
      //触摸开始与结束，手指移动的距离
      var disX = that.data.startX - endX;
      var delBtnWidth = that.data.delBtnWidth;
      //如果距离小于删除按钮的1/2，不显示删除按钮
      var txtStyle = disX > delBtnWidth / 2 ? "left:-" + delBtnWidth + "rpx" : "left:0rpx";
      //获取手指触摸的是哪一项
      var index = e.currentTarget.dataset.index;
      var list = that.data.rechargeList;
      list[index].txtStyle = txtStyle;
      //更新列表的状态
      that.setData({
        rechargeList: list
      });
    }
  },
  //手指触摸动作开始 记录起点X坐标
  touchstart: function (e) {
    //开始触摸时 重置所有删除
    this.data.rechargeList.forEach(function (v, i) {
      if (v.isTouchMove) //只操作为true的
        v.isTouchMove = false;
    })
    this.setData({
      startX: e.changedTouches[0].clientX,
      startY: e.changedTouches[0].clientY,
      rechargeList: this.data.rechargeList
    })
  },
  //滑动事件处理
  touchmove: function (e) {
    var that = this,
      index = e.currentTarget.dataset.index, //当前索引
      startX = that.data.startX, //开始X坐标
      startY = that.data.startY, //开始Y坐标
      touchMoveX = e.changedTouches[0].clientX, //滑动变化坐标
      touchMoveY = e.changedTouches[0].clientY, //滑动变化坐标
      //获取滑动角度
      angle = that.angle({
        X: startX,
        Y: startY
      }, {
        X: touchMoveX,
        Y: touchMoveY
      });
    that.data.rechargeList.forEach(function (v, i) {
      v.isTouchMove = false
      //滑动超过30度角 return
      if (Math.abs(angle) > 30) return;
      if (i == index) {
        if (touchMoveX > startX) //右滑
          v.isTouchMove = false
        else //左滑
          v.isTouchMove = true
      }
    })
  },
  /**
   * 计算滑动角度
   * @param {Object} start 起点坐标
   * @param {Object} end 终点坐标
   */
  angle: function (start, end) {
    var _X = end.X - start.X,
      _Y = end.Y - start.Y
    //返回角度 /Math.atan()返回数字的反正切值
    return 360 * Math.atan(_Y / _X) / (2 * Math.PI);
  },
  //查看问诊详情
  checkDetails(e) {
    if (this.data.confirm) {
      return;
    }
    this.data.confirm = true;
    wx.navigateTo({
      url: '/packageA/serviceDetails/serviceDetails?id=' + e.currentTarget.dataset.id,
    })
    this.data.confirm=false;
  },
})