const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');
Page({

  /**
   * 页面的初始数据
   */
  data: {
    list: [],
    noRecord: {
      winH: null,
    },
    page: 0,
    scrollFlag: '',
    scrollFlag1: true,
    success:false,
    isShow:false,
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    let that = this;
    wx.getSystemInfo({
      success: (res) => {
        that.setData({
          ['noRecord.winH']: res.windowHeight
        })
      }
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
this.getDealDetails()
  },
  

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {
    this.getDealDetails()
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {
    let that = this;
    let data = {
      unionid:  wx.getStorageSync('data').unionid,
      page: that.data.page
    }
    Service.getDealDetails(data).then((res)=>{
      if (res.data.length <= 0) {
        that.setData({
          scrollFlag: false,
          scrollFlag1: true,
          success: true
        })
        setTimeout(function () {
          that.setData({
            success: false
          })
        }, 2000)
      } else {
        if (res.data.length > 0) {
          var con = res.data
          var resu = that.data.list;
          for (let i = 0; i < con.length; i++) {
            resu.push(con[i])
          }
          that.setData({
            page: Number(that.data.page) + 15,
            scrollFlag: true,
            success: 1,
            list: resu
          })
        } else {
          that.setData({
            scrollFlag: false,
          })
        }
      }
    })
  },
  getDealDetails(){
    let data={
      unionid:wx.getStorageSync('data').unionid,
      page:0
    }
    Service.getDealDetails(data).then((res)=>{
      if(res.code==1){
        this.setData({
          list:res.data,
          page: 15,
          isShow:true
        })
        wx.stopPullDownRefresh();
      }
    })
  }
})