'use strict';
/**
 * service.js
 * 业务js层
 * add by LQ DateTime 2020-04-26
 */
///Promise封装对象
const wxRequest = require('wxRequest.js');
///路由配置
const config = require("config.js");
/**终止链式请求 */
function breakPromise() {
  return new Promise(function (resolve, reject) {
    reject('break');
  })
};
/**添加用户信息 */
function addUserInfo(param) {
  var addUserInfoUrl = config.url.addUserInfo;
  return wxRequest.getRequest(addUserInfoUrl, param);
};
/** 
 * 获取Im用户userSig
 * @add By lq DateTime 2020-04-26
 * @param {String} user 用户注册IM的id
 */
function getUserSig(user) {
  var getUserSigUrl = config.url.getUserSig;
  var data = {
    "user": user
    // "user": "oHhp80fVWvjJn2EYkB5XxhKnVBOo"
  }
  return wxRequest.getRequest(getUserSigUrl, data);
};
/** 获取openId方法
 * add By lq DateTime 2020-04-26
 * @param {string} code 用户code
 */
function getOpenId(code) {
  var getOpenId = config.url.getOpenId;
  var data = {};
  data.code = code;
  return wxRequest.postRequest(getOpenId, data);
};
/**
 * 获取用户数据
 * @param {string} openid 小程序id
 */
function getUserData(openid) {
  var getUserDataUrl = config.url.getUserData;
  var data = {};
  data.openid = openid;
  return wxRequest.postRequest(getUserDataUrl, data);
};
/**
 * 查询opneid 
 * @param {Object} param 
 */
function seeOpenId(param) {
  var seeOpenIdUrl = config.url.seeOpenId;
  return wxRequest.postRequest(seeOpenIdUrl, param);
};
/** 小程序强制更新
 * add By lq DateTime 2020-04-26
 */
function forcedUpdate() {
  var forcedUpdate = config.url.forcedUpdate;
  var data = {};
  return wxRequest.postRequest(forcedUpdate, data);
}
/**
 * 医生服务详情
 * @param {Object} param 
 */
function getDoctorDetail(param) {
  var getDoctorDetailUrl = config.url.getDoctorDetail;
  return wxRequest.postRequest(getDoctorDetailUrl, param);
}
/** 医生信息
 * @param {string} unitid 医生唯一标识
 */
function getDoctorInfo(unitid) {
  var getDoctorInfoUrl = config.url.getDoctorInfo;
  var data = {
    "unitid": unitid,
  }
  return wxRequest.postRequest(getDoctorInfoUrl, data);
}
/** 服务支付生成订单
 * @param {string} param.openid 用户openid
 * @param {Int32Array} param.gold 价格
 * @param {string} param.usename 购买类型
 */
function payRecord(param) {
  var payRecordUrl = config.url.payRecord;
  return wxRequest.postRequest(payRecordUrl, param);
}
/** 服务支付生成订单
 * @param {string} param.openid 用户openid
 * @param {Int32Array} param.gold 价格
 * @param {string} param.usename 购买类型
 */
function GZPayRecord(param) {
  var GZPayRecordUrl = config.url.GZPayRecord;
  return wxRequest.postRequest(GZPayRecordUrl, param);
}
/**插入支付记录
 * @param {string} param.unitid 医生唯一标识
 * @param {string} param.counsel 服务类型
 * @param {string} param.patient_unionid 病人微信唯一标识
 * @param {string} param.consultant_unionid 医生微信唯一标识
 * @param {string} param.put_trade_no 支付订单号
 * @param {Int32Array} param.money 支付金额
 * @param {string} param.type  服务类型//如果为在线问诊则传2为24小时，1包一月，3包三月，6包六月，否则则不传
 * @param {string} param.name 用户姓名
 * @param {Int32Array} param.age 用户年龄
 * @param {string} param.sex 用户性别
 * @param {string} param.phone 用户电话
 * @param {Int32Array} param.lastid  上一个购买用户id//上一个购买服务的用户信息，有就传，没有就不传
 */
function servicePay(param) {
  var servicePayUrl = config.url.servicePay;
  return wxRequest.postRequest(servicePayUrl, param);
}
/**判断是否有正在进行中或者未接诊的在线问诊服务 
 * @param {string} param.unitid 医生ID
 * @param {string} param.counsel 服务类型
 * @param {string} param.patient_unionid 病人微信唯一标识
 */
function isInquiry(param) {
  var isInquiryUrl = config.url.isInquiry;
  return wxRequest.postRequest(isInquiryUrl, param);
};
/**切换服务
 * @param {string} param.consultant_unionid 医生唯一标识
 * @param {string} param.counsel 服务类型
 * @param {string} param.patient_unionid 病人微信唯一标识
 * @param {string} param.relation_id 病人微信唯一标识
 */
function switchService(param) {
  var switchServiceUrl = config.url.switchService;
  return wxRequest.postRequest(switchServiceUrl, param);
};
/**药方详情 
 * @param {string} param.id 订单id
 * @param {string} param.inquiry_id 问诊id
 */
function getPrescription(param) {
  var getPrescriptionUrl = config.url.getPrescription;
  return wxRequest.postRequest(getPrescriptionUrl, param);
}
/**查询药物是否充足
 * @param {*} orderid 订单id
 */
function isDrugEnough(orderid) {
  var isDrugEnoughUrl = config.url.isDrugEnough;
  var data = {
    "orderid": orderid
  }
  return wxRequest.postRequest(isDrugEnoughUrl, data);
}
/** 
 * 药方支付
 * @param {*} param.orderid 订单id
 *  @param {*} param.ordernumber 订单号
 *  @param {*} param.address 地址id
 */
function prescriptionPay(param) {
  var prescriptionPayUrl = config.url.prescriptionPay; //支付
  return wxRequest.postRequest(prescriptionPayUrl, param);
}
/** 
 * 新增药方地址
 * @param {*} param.openid 用户openid
 * @param {*} param.unionid 用户唯一标识
 * @param {*} param.name 用户姓名
 * @param {*} param.phone 用户手机
 * @param {*} param.take_over 用户收货地址
 * @param {*} param.detail_address 用户详细地址
 */
function addAddress(param) {
  var addAddressUrl = config.url.addAddress;
  return wxRequest.postRequest(addAddressUrl, param);
}
/** 
 * 修改药方地址
 * @param {*} param.id 地址id
 * @param {*} param.name 用户姓名
 * @param {*} param.phone 用户手机
 * @param {*} param.take_over 用户收货地址
 * @param {*} param.detail_address 用户详细地址
 */
function editAddress(param) {
  var editAddressUrl = config.url.editAddress; //支付
  return wxRequest.postRequest(editAddressUrl, param);
}
/**
 * 是否可修改收货地址
 * @param {*} param.ordernumber //订单号
 */
function isEditAddress(param){
  var isEditAddressUrl = config.url.isEditAddress; //支付
  return wxRequest.postRequest(isEditAddressUrl, param);
}
/**
 * 药方地址列表
 * @param {*} param.openid 地址id
 * @param {*} param.unionid 用户姓名
 */
function addressList(param) {
  var addressListUrl = config.url.addressList; //支付
  return wxRequest.postRequest(addressListUrl, param);
}
/** 
 * 药方默认地址
 * @param {*} param.addressId 地址id
 * @param {*} param.openid 用户openid
 * @param {*} param.unionid 用户唯一id
 */
function defaultAddress(param) {
  var defaultAddressUrl = config.url.defaultAddress; //支付
  return wxRequest.postRequest(defaultAddressUrl, param);
}
/** 检测是否允许查看报告
 * @param {*} src 报告id
 */
function isReport(param) {
  var isReportUrl = config.url.isReport
  return wxRequest.postRequest(isReportUrl, param);
}
/** 添加用户购买信息
 * @param {*} param.unionid 用户唯一标识
 * @param {*} param.name name
 * @param {*} param.age age
 * @param {*} param.sex sex
 * @param {*} param.phone phone
 */
function addUserBuyInfo(param) {
  var addUserBuyInfoUrl = config.url.addUserBuyInfo;
  return wxRequest.postRequest(addUserBuyInfoUrl, param);
}
/** 编辑用户购买信息
 * @param {*} param.id 列表id
 * @param {*} param.unionid 用户唯一标识
 * @param {*} param.namephone 用户姓名
 * @param {*} param.age 用户年龄
 * @param {*} param.sex 用户性别
 * @param {*} param.phone 手机号
 */
function editUserBuyInfo(param) {
  var editUserBuyInfoUrl = config.url.editUserBuyInfo; //支付
  return wxRequest.postRequest(editUserBuyInfoUrl, param);
}
/** 删除用户购买信息
 * @param {*} param.id 微信用户唯一标识
 */
function delUserbuyInfo(param) {
  var delUserbuyInfoUrl = config.url.delUserbuyInfo;
  return wxRequest.postRequest(delUserbuyInfoUrl, param);
}
/** 用户购买信息列表 
 * @param {*} param.unionid 用户唯一标识
 */
function userBuyInfoList(param) {
  var userBuyInfoListUrl = config.url.userBuyInfoList;
  return wxRequest.postRequest(userBuyInfoListUrl, param);
}
/** 上次用户购买信息
 * @param {*} param.unionid 用户唯一标识
 */
function lastUserBuyInfo(param) {
  var lastUserBuyInfoUrl = config.url.lastUserBuyInfo;
  return wxRequest.postRequest(lastUserBuyInfoUrl, param);
}
/** 微信授权获取用户手机号
 * @param {*} param.session_key 微信key
 * @param {*} param.encryptedData 微信Data
 * @param {*} param.iv 微信iv
 */
function getWxUserPhone(param) {
  var getWxUserPhoneUrl = config.url.getWxUserPhone;
  return wxRequest.postRequest(getWxUserPhoneUrl, param);
}

function getCode(param) {
  var getCodeUrl = config.url.getCode;
  return wxRequest.postRequest(getCodeUrl, param);
}
/** 未做量表提醒
 * @param {*} param.openid openid
 */
function getNotResult(param) {
  var getNotResultUrl = config.url.getNotResult;
  return wxRequest.postRequest(getNotResultUrl, param);
}
/** 首页医生数据
 * @param {*} param.openid
 */
function getDoctorIndex() {
  var getDoctorIndexUrl = config.url.getDoctorIndex;
  var data = {}
  return wxRequest.postRequest(getDoctorIndexUrl, data);
}
//查询医生数据
function screenDoctor(param) {
  var screenDoctorUrl = config.url.screenDoctor;
  return wxRequest.postRequest(screenDoctorUrl, param);
}
/**发票列表
 * @param {*} param 
 */
function getInvoiceList(param) {
  var getInvoiceListUrl = config.url.getInvoiceList;
  return wxRequest.postRequest(getInvoiceListUrl, param);
};

function getInvoiceStatus(param) {
  var getInvoiceStatusUrl = config.url.getInvoiceStatus;
  return wxRequest.postRequest(getInvoiceStatusUrl, param);
}

function getInvoiceDetail(param) {
  var getInvoiceDetailUrl = config.url.getInvoiceDetail;
  return wxRequest.postRequest(getInvoiceDetailUrl, param);
}

function getInvoiceInfo(param) {
  var getInvoiceInfoUrl = config.url.getInvoiceInfo;
  return wxRequest.postRequest(getInvoiceInfoUrl, param);
}

function saveInvoiceInfo(param) {
  var saveInvoiceInfoUrl = config.url.saveInvoiceInfo;
  return wxRequest.postRequest(saveInvoiceInfoUrl, param);
}

function anewInvoice(param) {
  var anewInvoiceUrl = config.HOST + param.url;
  return wxRequest.postRequest(anewInvoiceUrl, param);
}

function editAgainEmail(param) {
  var editAgainEmailUrl = config.url.editAgainEmail;
  return wxRequest.postRequest(editAgainEmailUrl, param);
}

function getTaxpayers(param) {
  var getTaxpayersUrl = config.url.getTaxpayers;
  return wxRequest.postRequest(getTaxpayersUrl, param);
}

function sendEmail(g_id) {
  var sendEmailUrl = config.url.sendEmail;
  var data = {
    g_id: g_id,
  }
  return wxRequest.postRequest(sendEmailUrl, data);
}

function seeInvoice(g_id) {
  var seeInvoiceUrl = config.url.seeInvoice;
  var data = {
    g_id: g_id,
  }
  return wxRequest.postRequest(seeInvoiceUrl, data);
}

function getChatDoctor(param) {
  var getChatDoctorUrl = config.url.getChatDoctor;
  return wxRequest.postRequest(getChatDoctorUrl, param);
}

function getFollowUpList(param) {
  var getFollowUpListUrl = config.url.getFollowUpList;
  return wxRequest.postRequest(getFollowUpListUrl, param);
};

function getDealDetails(param) {
  var getDealDetailsUrl = config.url.getDealDetails;
  return wxRequest.postRequest(getDealDetailsUrl, param);
};

function getReportList(param) {
  var getReportListUrl = config.url.getReportList;
  return wxRequest.postRequest(getReportListUrl, param);
};

function delReport(param) {
  var delReportUrl = config.url.delReport;
  return wxRequest.postRequest(delReportUrl, param);
}

function goSetTel(param) {
  var goSetTelUrl = config.url.goSetTel;
  return wxRequest.postRequest(goSetTelUrl, param);
};

function getIsCheck(param) {
  var getIsCheckUrl = config.url.getIsCheck;
  return wxRequest.postRequest(getIsCheckUrl, param);
};

function getServiceList(param) {
  var getServiceListUrl = config.url.getServiceList;
  return wxRequest.postRequest(getServiceListUrl, param);
}

function servicePayEdit(param) {
  var servicePayEditUrl = config.url.servicePayEdit;
  return wxRequest.postRequest(servicePayEditUrl, param);
}

function sendCard(param) {
  var sendCardUrl = config.url.sendCard;
  return wxRequest.postRequest(sendCardUrl, param);
};

function serviceDetail(id) {
  var serviceDetailUrl = config.url.serviceDetail;
  var data = {
    "id": id,
  }
  return wxRequest.postRequest(serviceDetailUrl, data);
};

function getFriendList(unionid) {
  var getFriendListUrl = config.url.getFriendList;
  var data = {
    "unionid": unionid,
  }
  return wxRequest.postRequest(getFriendListUrl, data);
}

function addFriend(param) {
  var addFriendUrl = config.url.addFriend;
  return wxRequest.postRequest(addFriendUrl, param);
}

function delFriend(param) {
  var delFriendUrl = config.url.delFriend;
  return wxRequest.postRequest(delFriendUrl, param);
}

function appAddFriend(param) {
  var appAddFriendUrl = config.url.appAddFriend;
  return wxRequest.postRequest(appAddFriendUrl, param);
}

function loadScene(param) {
  var loadSceneUrl = config.url.loadScene;
  return wxRequest.postRequest(loadSceneUrl, param);
}
function loadIMScene(param) {
  var loadIMSceneUrl = config.url.loadIMScene;
  return wxRequest.postRequest(loadIMSceneUrl, param);
}
/**
 * 用户购买服务状态
 */
function seeBuyStaus(param) {
  var seeBuyStausUrl = config.url.seeBuyStaus;
  return wxRequest.postRequest(seeBuyStausUrl, param);
}

function delService(id) {
  var delServicUrl = config.url.delService;
  var data = {
    id: id
  }
  return wxRequest.postRequest(delServicUrl, data);
}

function getDrugList(unionid) {
  var getDrugListUrl = config.url.getDrugList;
  var data = {
    unionid: unionid
  }
  return wxRequest.postRequest(getDrugListUrl, data);
}

function getDrugDetail(param) {
  var getDrugDetailUrl = config.url.getDrugDetail;
  return wxRequest.postRequest(getDrugDetailUrl, param);
}

function getRecipeDetails(param) {
  var getRecipeDetailstUrl = config.url.getRecipeDetails;
  return wxRequest.postRequest(getRecipeDetailstUrl, param);
}

function buyDrugList(param) {
  var buyDrugListUrl = config.url.buyDrugList;
  return wxRequest.postRequest(buyDrugListUrl, param);
}

function delBuyDrug(param) {
  var delBuyDrugUrl = config.url.delBuyDrug;
  return wxRequest.postRequest(delBuyDrugUrl, param);
}

function confirmReceipt(param) {
  var confirmReceiptUrl = config.url.confirmReceipt;
  return wxRequest.postRequest(confirmReceiptUrl, param);
}

function getQuick(param) {
  var getQuickUrl = config.url.getQuick;
  return wxRequest.postRequest(getQuickUrl, param);
}

function getFreeChat(param) {
  var getFreeChatUrl = config.url.getFreeChat;
  return wxRequest.postRequest(getFreeChatUrl, param);
}

function setFreeSend(param) {
  var setFreeSendUrl = config.url.setFreeSend;
  return wxRequest.postRequest(setFreeSendUrl, param);
}

function getSendReports(param) {
  var getSendReportsUrl = config.url.getSendReports;
  return wxRequest.postRequest(getSendReportsUrl, param);
}

function getRoomUserSig(unionid) {
  var getRoomUserSigUrl = config.url.getRoomUserSig;
  var data = {
    'unionid': unionid,
  }
  return wxRequest.postRequest(getRoomUserSigUrl, data);
}

function checkCard(param) {
  var checkCardUrl = config.url.checkCard;
  return wxRequest.postRequest(checkCardUrl, param);
}

function getTestInfo(param) {
  var getTestInfoUrl = config.url.getTestInfo;
  return wxRequest.postRequest(getTestInfoUrl, param);
}

function acceptFollowUp(param) {
  var acceptFollowUpUrl = config.url.acceptFollowUp;
  return wxRequest.postRequest(acceptFollowUpUrl, param);
}

function getPayStatus(param) {
  var getPayStatusUrl = config.url.getPayStatus;
  return wxRequest.postRequest(getPayStatusUrl, param);
}

function paySucceedCallback(param) {
  var paySucceedCallbackUrl = config.url.paySucceedCallback;
  return wxRequest.postRequest(paySucceedCallbackUrl, param);
}

function getChatMsgLog(param) {
  var getChatMsgLogUrl = config.url.getChatMsgLog;
  return wxRequest.postRequest(getChatMsgLogUrl, param);
}

function endInquiry(param) {
  var endInquiryUrl = config.url.endInquiry;
  return wxRequest.postRequest(endInquiryUrl, param);
}

function refuseInquiry(param) {
  var refuseInquiryUrl = config.url.refuseInquiry;
  return wxRequest.postRequest(refuseInquiryUrl, param);
}

function getOrderStatus(param) {
  var getOrderStatusUrl = config.url.getOrderStatus;
  return wxRequest.postRequest(getOrderStatusUrl, param);
}

function myServerList(param) {
  var myServerListUrl = config.url.myServerList;
  return wxRequest.postRequest(myServerListUrl, param);
}

function contactDoctor(param) {
  var contactDoctorUrl = config.url.contactDoctor;
  return wxRequest.postRequest(contactDoctorUrl, param);
}

function logisticsInfo(param) {
  var logisticsInfoUrl = config.url.logisticsInfo;
  return wxRequest.postRequest(logisticsInfoUrl, param);
}

function firendAfterRoom(param) {
  var firendAfterRoomUrl = config.url.firendAfterRoom;
  return wxRequest.postRequest(firendAfterRoomUrl, param);
}

function drogOrderDetail(param) {
  var drogOrderDetailUrl = config.url.drogOrderDetail;
  return wxRequest.postRequest(drogOrderDetailUrl, param);
}

function getBusStopListPromise(sid, stopType) {
  var getStopListUrl = config.url.getBusStopList;
  var data = {
    "sid": sid,
    "stopType": stopType
  }
  return wxRequest.postRequest(getStopListUrl, data);
};

module.exports = {
  breakPromise: breakPromise, //中止请求
  getUserSig: getUserSig, //获取Im用户userSig
  addUserInfo: addUserInfo, //添加用户信息
  getOpenId: getOpenId, //获取openId方法
  getUserData: getUserData, //获取用户数据
  seeOpenId: seeOpenId, //查询openid
  forcedUpdate: forcedUpdate, //小程序强制更新
  getDoctorDetail: getDoctorDetail, //医生服务详情
  getDoctorInfo: getDoctorInfo, //医生信息
  payRecord: payRecord, //支付生成订单
  GZPayRecord: GZPayRecord, //广州医院支付
  servicePay: servicePay, //插入支付记录
  isInquiry: isInquiry, //判断是否有正在进行中或者未接诊的在线问诊服务
  switchService: switchService, //服务切换
  getPrescription: getPrescription, //药方详情
  isDrugEnough: isDrugEnough, //查询药物是否充足
  prescriptionPay: prescriptionPay, //药方支付
  addAddress: addAddress, //新增地址
  editAddress: editAddress, //修改地址
  isEditAddress:isEditAddress,//判断是否修改地址
  addressList: addressList, //地址列表
  defaultAddress: defaultAddress, //地址详情
  isReport: isReport, //检测是否允许查看报告
  addUserBuyInfo: addUserBuyInfo, //添加用户购买信息
  editUserBuyInfo: editUserBuyInfo, //修改用户购买信息
  delUserbuyInfo: delUserbuyInfo, //删除用户购买信息
  userBuyInfoList: userBuyInfoList, //用户购买信息列表
  lastUserBuyInfo: lastUserBuyInfo, //上次用户购买信息
  getWxUserPhone: getWxUserPhone, //微信授权获取用户手机号
  getCode: getCode, //获取验证码
  getNotResult: getNotResult, //未做量表提醒
  getDoctorIndex: getDoctorIndex, //首页医生数据
  screenDoctor: screenDoctor, //搜索医生列表
  getInvoiceList: getInvoiceList, //发票列表
  getInvoiceStatus: getInvoiceStatus, //发票状态
  getInvoiceDetail: getInvoiceDetail, //发票详情
  saveInvoiceInfo: saveInvoiceInfo, //保存发票信息
  getInvoiceInfo: getInvoiceInfo, //发票信息
  anewInvoice: anewInvoice, //重新开票
  editAgainEmail: editAgainEmail, //修改发票邮箱
  sendEmail: sendEmail, //提交开票
  seeInvoice: seeInvoice, //查看发票
  getTaxpayers: getTaxpayers, //自动获取纳税人识别号
  getChatDoctor: getChatDoctor, //获取正在聊天的医生信息
  getFollowUpList: getFollowUpList, //预约记录列表
  getDealDetails: getDealDetails, //交易记录
  getReportList: getReportList, //报告列表
  delReport: delReport, //删除报告
  goSetTel: goSetTel, //获取手机号
  getIsCheck: getIsCheck, //是否允许查看报告
  getServiceList: getServiceList, //获取服务列表
  servicePayEdit: servicePayEdit, //获取支付信息
  sendCard: sendCard, //保存发送给医生的用户信息
  serviceDetail: serviceDetail, //服务详情
  getFriendList: getFriendList, //获取好友列表
  addFriend: addFriend, //添加好友
  delFriend: delFriend, //删除好友
  appAddFriend: appAddFriend, //app.js添加好友
  loadScene: loadScene, //加载量表二维码场景
  loadIMScene:loadIMScene,//加载IM量表支付场景
  seeBuyStaus: seeBuyStaus, //用户购买服务状态
  endInquiry: endInquiry, //同意结束服务
  refuseInquiry: refuseInquiry, //拒绝结束服务
  delService: delService, //删除服务
  getDrugList: getDrugList, //处方列表
  getDrugDetail: getDrugDetail, //处方详情
  buyDrugList: buyDrugList, //购药记录列表
  delBuyDrug: delBuyDrug, //删除购药记录
  confirmReceipt: confirmReceipt, //确认收货
  getQuick: getQuick, //快速开药
  getRecipeDetails: getRecipeDetails, //正常开药
  getFreeChat: getFreeChat, //获取免费咨询次数
  setFreeSend: setFreeSend, //修改免费咨询次数
  getSendReports: getSendReports, //获取发送报告列表
  getRoomUserSig: getRoomUserSig, //获取roomUserSig
  checkCard: checkCard, //验证身份证与姓名
  getTestInfo: getTestInfo, //获取检测信息
  acceptFollowUp: acceptFollowUp, //接受随访
  getPayStatus: getPayStatus, //获取药方支付状态
  paySucceedCallback: paySucceedCallback, //支付成功回调
  getChatMsgLog: getChatMsgLog, //获取消息历史记录
  myServerList: myServerList, //我的服务列表
  contactDoctor: contactDoctor, //联系医生
  logisticsInfo: logisticsInfo, //物流信息
  firendAfterRoom: firendAfterRoom, //成功加好友之后选择身份信息进入群聊房间
  drogOrderDetail: drogOrderDetail, //药品订单详情
}