// pages/prescription/addsite/addsite.js
const Service = require('../../utils/service.js');
Page({

	/**
	 * 页面的初始数据
	 */
	data: {
		id: '',
		name: '',
		phone: '',
		take_over: ['请选择', '', ''],
		detail_address: '',
	},
	/**
	 * 生命周期函数--监听页面加载
	 */
	onLoad: function (options) {
		let that = this;
		if(options.ordernumber){
			that.data.ordernumber=options.ordernumber;
		}
		if (options.item) {
			wx.setNavigationBarTitle({
				title: "修改地址"
			})
			let item = JSON.parse(options.item)
			console.log(item)
			that.setData({
				id: item.id,
				name: item.name,
				phone: item.phone,
				take_over: [item.province,item.city, item.area],
				detail_address: item.detail_address
			})
		} else {
			wx.setNavigationBarTitle({
				title: "添加地址"
			})
		}
	},
	/**
	 * 保存修改
	 * @param {object} e 
	 */
	formSubmit: function (e) {
		var that = this
		let item = wx.getStorageSync('data');
		//id不为空属于修改
		if (that.data.id != '') {
			console.log(2)
			let data = {};
			data.id = that.data.id
			data.name = e.detail.value.name;
			data.phone = e.detail.value.phone;
			if(data.take_over=='请选择'){
				wx.showModal({
					title: '提示',
					showCancel: false,
					content: '请选择地址',
				})
				return;
			}
			if (e.detail.value.take_over[1] == '北京市' || e.detail.value.take_over[1] == '天津市'||e.detail.value.take_over[1] == '上海市'||e.detail.value.take_over[0]=="重庆市") {
				data.take_over = e.detail.value.take_over[0] + e.detail.value.take_over[2];
			} else {
				data.take_over = e.detail.value.take_over[0] + e.detail.value.take_over[1] + e.detail.value.take_over[2];
			}
			data.addressId = JSON.stringify({
				province: e.detail.value.take_over[0],
				city: e.detail.value.take_over[1],
				area: e.detail.value.take_over[2]
			});
			data.detail_address = e.detail.value.detail_address;
			//orderNumber不为空属于修改订单地址
			if(that.data.ordernumber){
				data.ordernumber = that.data.ordernumber;
			}
			//修改地址
			Service.editAddress(data).then((res) => {
				if (res.code == 1) {
					var data={
						addressId:res.data,
						openid:item.openid,
						unionid:item.unionid
					}
					//修改默认地址
					Service.defaultAddress(data).then((res) => {})
					wx.navigateBack({
						delta:1
					})
				} else {
					wx.showModal({
						title: '提示',
						showCancel: false,
						content: res.msg,
					})
				}
			})
		}
		/**新添 */ 
		else {
			console.log(1)
			let data = {};
			data.openid = item.openid;
			data.unionid = item.unionid;
			data.name = e.detail.value.name;
			data.phone = e.detail.value.phone;
			if (e.detail.value.take_over[1] == '北京市' || e.detail.value.take_over[1] == '天津市'||e.detail.value.take_over[1] == '上海市'||e.detail.value.take_over[0]=="重庆市") {
				data.take_over = e.detail.value.take_over[0] + e.detail.value.take_over[2];
			} else {
				data.take_over = e.detail.value.take_over[0] + e.detail.value.take_over[1] + e.detail.value.take_over[2];
			}
			data.addressId = JSON.stringify({
				province: e.detail.value.take_over[0],
				city: e.detail.value.take_over[1],
				area: e.detail.value.take_over[2]
			});
			data.detail_address = e.detail.value.detail_address;
			if(data.take_over=='请选择'){
				wx.showModal({
					title: '提示',
					showCancel: false,
					content: '请选择地址',
				})
				return;
			}
			Service.addAddress(data).then((res) => {
				if (res.code == 1) {
					console.log("res", res)
					var data={
						addressId:res.data,
						openid:item.openid,
						unionid:item.unionid
					}
					Service.defaultAddress(data).then((res) => {})
					wx.navigateBack({
						delta: 2
					})
				} else {
					wx.showModal({
						title: '提示',
						showCancel: false,
						content: res.msg,
					})
				}
			})
		}
	},
	name: function (e) {
		e.detail.value
	},
	bindRegionChange: function (e) {
		console.log('picker发送选择改变，携带值为', e.detail.value)
		this.setData({
			take_over: e.detail.value
		})
	},
	/**
	 * 生命周期函数--监听页面初次渲染完成
	 */
	onReady: function () {

	},

	/**
	 * 生命周期函数--监听页面显示
	 */
	onShow: function () {

	},

	/**
	 * 生命周期函数--监听页面隐藏
	 */
	onHide: function () {

	},

	/**
	 * 生命周期函数--监听页面卸载
	 */
	onUnload: function () {

	},

	/**
	 * 页面相关事件处理函数--监听用户下拉动作
	 */
	onPullDownRefresh: function () {

	},

})