// pages/prescription/site/site.js
var Service = require('../../utils/service.js');
Page({

	/**
	 * 页面的初始数据
	 */
	data: {
		openid:'',
		unionid:'',
		list:[]
	},

	/**
	 * 生命周期函数--监听页面加载
	 */
	onLoad: function (options) {
		
	},
	goback(e){
		wx.showLoading();
		console.log(e)
		var data={
			addressId:e.currentTarget.dataset.item.id,
			openid:e.currentTarget.dataset.item.openid,
			unionid:e.currentTarget.dataset.item.unionid
		}
		Service.defaultAddress(data).then(() => {})
		wx.navigateBack({
			delta: 1
		})
		wx.hideLoading();
	},
	addsite(e){
		wx.showLoading();
		let item = JSON.stringify(e.currentTarget.dataset.item);
		if (e.currentTarget.dataset.num == 0){
			wx.navigateTo({
				url: '/packageA/addsite/addsite',
			})
		} else if (e.currentTarget.dataset.num == 1){
			wx.navigateTo({
				url: '/packageA/addsite/addsite?id=' + e.currentTarget.dataset.id + "&item=" + item,
			})
		}
		wx.hideLoading();
	},
	/**
	 * 生命周期函数--监听页面初次渲染完成
	 */
	onReady: function () {

	},

	/**
	 * 生命周期函数--监听页面显示
	 */
	onShow: function () {
		var that = this
		var item = wx.getStorageSync('data');
		var data = {};
		data.openid = item.openid;
		data.unionid = item.unionid;
		Service.addressList(data).then((res)=> {
			console.log("res",res)
			if (res.code == 1) {
				that.setData({
					list:res.data
				})
			}
		})
	},

	/**
	 * 生命周期函数--监听页面隐藏
	 */
	onHide: function () {

	},

	/**
	 * 生命周期函数--监听页面卸载
	 */
	onUnload: function () {

	},

	/**
	 * 页面相关事件处理函数--监听用户下拉动作
	 */
	onPullDownRefresh: function () {

	},

	/**
	 * 页面上拉触底事件的处理函数
	 */
	onReachBottom: function () {

	},
})