// pages/fapiao/fapiao.js
const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');
const Tim = require('../../utils/tim.js');
const App = getApp();
Page({
  /**
   * 页面的初始数据
   */
  data: {
    rechargeList: [],
    // 无记录模板数据
    noRecord: {
      winH: null,
    },
    headTab: 0,
    _type: 0,
    page: 1,
    success: true,
    ishow:false
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    let that = this;
    wx.getSystemInfo({
      success: (res) => {
        that.setData({
          ['noRecord.winH']: res.windowHeight
        })
      }
    })
    let _type = options.type || 0; // 从发票弹窗进入
    if (_type == 1) {
      this.setData({
        headTab: 1
      })
    }
    this.setData({
      _type: _type
    })
  },
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    let that = this;
    //获得modal组件
    that.modal = that.selectComponent("#modal");
    that.login = that.selectComponent("#login");
    that.answer = that.selectComponent("#answer");
    wx.login({
      success: function (msg) {
        Service.getOpenId(msg.code).then((res) => {
          wx.setStorageSync('user', res)
          return Service.getUserData(res.openid)
        }).then((res) => {
          if (Util.isEmpty(res.unionid)) {
            that.setData({
              ishow: true,
            })
            that.login.showLogin();
          } else {
            wx.setStorageSync('data', res)
            that.setData({
              userInfo: res,
            })
            if (!App.globalData.isLogin) {
              Service.getUserSig(res.unionid).then((res) => {
                return Tim.login(res.data.userid, res.data.sign)
              }).then(function (imResponse) {
                console.log('%c登录成功', "color:#04BE02", imResponse);
                if (imResponse.data.repeatLogin === true) {
                  // 标识账号已登录，本次登录操作为重复登录。v2.5.1 起支持
                  console.log('"%c本次登录操作为重复登录', "color:#ff0000", imResponse.data.errorInfo);
                }
                that.getList(1, that.data.headTab);
              }).catch(function (imError) {
                console.log('"%c登录失败', "color:#ff0000", imError); // 登录失败
                console.warn('login error:', imError); // 登录失败的相关信息
              });
            } else {
              that.getList(1, that.data.headTab);
            }
          }
        })
      }
    })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },
  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {
    this.data.page = 1;
    this.getList(1, this.data.headTab);
  },
  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {
    var page = this.data.page + 1;
    this.setData({
      scrollFlag: true,
      success: false,
      page: page
    })
    this.getList(page, this.data.headTab)
  },
     /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {
    return {
      title: '开具发票',
      path: '/packageB/invoice/invoice',
    }
  },
  /* 切换报告和发票 */
  switchTab(e) {
    // console.log(e, 'eeee')
    let index = e.currentTarget.dataset.index;
    this.setData({
      headTab: index,
      page: 1,
    });
    this.getList(1, index);
  },
  /* 获取item */
  getList(page, e) {
    let that = this
    let data = {};
    data.openid = wx.getStorageSync('data').openid;
    data.type = e;
    data.page = page;
    Service.getInvoiceList(data).then((res) => {
      var rechargeList = that.data.rechargeList;
      if (page > 1 && res.data.length > 0) {
        for (let i = 0; i < res.data.length; i++) {
          rechargeList.push(res.data[i])
        }
        that.setData({
          success: true
        })
      } else if (page > 1 && res.data.length == 0) {
        that.setData({
          scrollFlag: false,
          scrollFlag1: true,
        })
        setTimeout(function () {
          that.setData({
            success: true
          })
        }, 2000)
      } else {
        rechargeList = res.data;
      }
      wx.stopPullDownRefresh()
      if (rechargeList.length > 0) {
        that.setData({
          rechargeList: rechargeList,
          tickShow: false,
          ishow:true
        })
      } else {
        that.setData({
          rechargeList: [],
          tickShow: true,
          ishow:true
        })
      }
    })
  },
  /* 点击item */
  goInvoicing(e) {
    let invoice = e.currentTarget.dataset.invoice;
    let gid = e.currentTarget.dataset.gid;
    let money = e.currentTarget.dataset.money;
    let descs = e.currentTarget.dataset.descs;
    if (invoice == 0) {
      wx.navigateTo({
        url: '../invoiceInfo/invoiceInfo?money=' + money + '&gid=' + gid + '&descs=' + descs,
      })
    } else {
      wx.navigateTo({
        url: '../invoiceDetail/invoiceDetail?gid=' + gid,
      })
    }
  },
    //登录回调
    _refreshEvent() {
      console.log("刷新");
      this.onShow();
    },
})