// components/login/login.js
const Util = require('../../utils/util.js');
const app = getApp();
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    loginTitle: {
      type: String,
      value: '请先授权登录',
    },
    loginMsg: {
      type: String,
      value: '为了更好的为您提供服务，请允许微信授权后再使用功能',
    },
    loginBtn:{
      type: String,
      value: '登 录',
    },
    showClose:{
      type:Boolean,
      value:false
    },
  },

  /**
   * 组件的初始数据
   */
  data: {},

  /**
   * 组件的方法列表
   */
  methods: {
    //隐藏弹框
    hideLogin() {
      this.setData({
        isShow: false
      })
    },
    //展示弹框
    showLogin() {
      this.setData({
        isShow: true
      })
    },
    getInfo: function (e) {
      let that = this;
      if (e.detail.userInfo) {
        wx.showLoading({
          title: '正在登录',
        })
        app.getUserInfo(function (cb) {
          if (!Util.isEmpty(cb)) {
            wx.showToast({
              title: '登录成功',
            })
            that.hideLogin();
            that._refreshEvent();
          }
        });
      }
    },
    //回调
    _refreshEvent() {
      this.triggerEvent('refreshEvent')
    },
    //默认Tap事件，阻止开发工具警告消息
    true(){},
  }
})