const Service = require('../../utils/service.js');
const {
	debouce
} = require('../../utils/util.js'); //防抖函数
const Util = require('../../utils/util.js');
Page({

	/**
	 * 页面的初始数据
	 */
	data: {
		nav: 0,
		status: '',
		noRecord: {
			winH: null,
		},
		showview: false,
		list: [],
		page: 1
	},

	/**
	 * 生命周期函数--监听页面加载
	 */
	onLoad: function (options) {
		var that = this
		if (!Util.isEmpty(options.status)) {
			that.setData({
				status: options.status,
				nav: options.status
			})
		}
	},
	onShow: function () {
		var that = this
		that.getList(1, that.data.nav)
	},
	/**
	 * 页面相关事件处理函数--监听用户下拉动作
	 */
	onPullDownRefresh: function () {
		var that = this
		that.data.page = 1;
		wx.showNavigationBarLoading() //在标题栏中显示加载
		setTimeout(function () {
			that.getList(1, that.data.nav)
			wx.hideNavigationBarLoading() //完成停止加载
			wx.stopPullDownRefresh() //停止下拉刷新
		}, 1500);
	},
	/**
	 * 页面上拉触底事件的处理函数
	 */
	onReachBottom: function () {
		var that = this
		var page = that.data.page + 1;
		that.setData({
			scrollFlag: true,
			success: false,
			page: page
		})
		that.getList(page, that.data.nav)
	},
	//删除订单
	deleBtn: debouce(function (e) {
		var that = this
		wx.showModal({
			content: '是否确认删除订单',
			success(res) {
				if (res.confirm) {
					let data = {
						unionid: wx.getStorageSync("data").unionid,
						ordernumber: e.currentTarget.dataset.ordernumber
					};
					Service.delBuyDrug(data).then((res) => {
						if (res.code == 1) {
							wx.showToast({
								title: '删除成功',
								icon: 'success',
								mask: true
							})
							that.getList(1, that.data.nav)
						}
					}).catch((Error) => {
						console.warn('error:', Error); // 获取会话资料失败的相关信息
					});
				}
			}
		})
	}, 1000, true),
	//获取列表
	getList: function (page, status) {
		var that = this
		var data = {
			page: page,
			// unionid:'oHhp80XTpjf-JKvU94VEztv3aLhc',
			unionid: wx.getStorageSync('data').unionid,
			status: status
		};
		Service.buyDrugList(data).then((res) => {
			console.log("res", res)
			var list = that.data.list;
			if (page > 1 && res.data.length > 0) {
				for (let i = 0; i < res.data.length; i++) {
					list.push(res.data[i])
				}
				that.setData({
					success: true
				})
			} else if (page > 1 && res.data.length == 0) {
				that.setData({
					scrollFlag: false,
					scrollFlag1: true,
				})
				setTimeout(function () {
					that.setData({
						success: true
					})
				}, 2000)
			} else {
				list = res.data;
			}
			wx.stopPullDownRefresh()
			if (list.length > 0) {
				that.setData({
					list: list,
					showview: true
				})
			} else {
				that.setData({
					list: [],
					showview: true
				})
			}
		}).catch(function (Error) {
			console.warn('error:', Error); // 获取会话资料失败的相关信息
		});
	},
	//选择topTab页
	nav: function (e) {
		let _this = this
		_this.setData({
			nav: e.currentTarget.dataset.index,
			page: 1,
			showview: false
		})
		_this.getList(1, e.currentTarget.dataset.index)
	},
	//确认收货
	confirmReceipt: debouce(function (e) {
		let that = this
		let data = {
			unionid: wx.getStorageSync('data').unionid,
			ordernumber: e.currentTarget.dataset.num
		}
		wx.showModal({
			content: '确认收货',
			success(ress) {
				if (ress.confirm) {
					Service.confirmReceipt(data).then((res) => {
						console.log("confirmReceipt", res)
						wx.showToast({
							title: res.msg,
						})
						that.getList(1, 3)
					})
				} else if (ress.cancel) {
					console.log('用户点击取消')
				}
			}
		})
	}, 1000, true),
	// 查看物流-待发货
	// goLogistics1: function (e) {
	// 	console.log(1,e.currentTarget.dataset.id)
	// 	wx.navigateTo({
	// 		url: e.currentTarget.dataset.src +'?img=' + e.currentTarget.dataset.img + '&status=' + e.currentTarget.dataset.status + '&num=' + e.currentTarget.dataset.num + '&tel=' + e.currentTarget.dataset.tel + '&ordernumber=' + e.currentTarget.dataset.ordernumber+'&com='+e.currentTarget.dataset.com +'&address='+JSON.stringify(e.currentTarget.dataset.address),
	// 	})
	// },
	/**
	 *修改地址-待发货2
	 */
	editAddress: debouce(function (e) {
		Service.isEditAddress({
			ordernumber: e.currentTarget.dataset.ordernumber
		}).then((res) => {
			if (res.code == 1) {
				wx.navigateTo({
					url: '/packageA/addsite/addsite?item=' + JSON.stringify(e.currentTarget.dataset.address) + '&ordernumber=' + e.currentTarget.dataset.ordernumber + '&type=1',
				})
			}else{
				wx.showToast({
					title: res.msg,
					icon: 'success',
					mask: true
				})
			}
		})
	}, 1000, true),
	/**
	 * 订单详情-待发货2，已发货3，已完成4
	 */
	goOrderDetail: debouce(function (e) {
		wx.navigateTo({
			url: '/packageA/drugOrderDetail/drugOrderDetail?id=' + e.currentTarget.dataset.id,
		})
	}, 1000, true),
	//查看物流-待收货+已完成
	goLogistics: debouce(function (e) {
		wx.navigateTo({
			url: e.currentTarget.dataset.src + "?num=" + e.currentTarget.dataset.num + '&tel=' + e.currentTarget.dataset.tel + '&ordernumber=' + e.currentTarget.dataset.ordernumber + '&img=' + e.currentTarget.dataset.img + '&status=' + e.currentTarget.dataset.status + '&com=' + e.currentTarget.dataset.com + '&address=' + JSON.stringify(e.currentTarget.dataset.address),
		})
	}, 1000, true),
	/**
	 * 立即支付
	 */
	goPay: debouce(function (e) {
		let that = this;
		let data = {
			prescription: e.currentTarget.dataset.id,
			patient_unionid: wx.getStorageSync('data').unionid,
			isquick: e.currentTarget.dataset.isquick
		}
		Service.getPayStatus(data).then((res) => {
			if (res.code == 1) {
				that.onShow();
			} else if (res.code == -1) {
				wx.navigateTo({
					url: '/packageA/drugOrderInfo/drugOrderInfo?scene=' + e.currentTarget.dataset.id + "&isQuick=" + e.currentTarget.dataset.isquick,
				})
			} else if (res.code == 2) {
				wx.showToast({
					title: res.msg,
					icon: 'none'
				})
			}
		})
	}, 1000, true),
})