// packageA/drugOrderDetail/drugOrderDetail.js
const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');
Page({

	/**
	 * 页面的初始数据
	 */
	data: {
		list: ["1"],
		index: 0
	},

	/**
	 * 生命周期函数--监听页面加载
	 */
	onLoad: function (options) {
		var that=this;
		that.setData({
			id:options.id,
		})
	},

	/**
	 * 生命周期函数--监听页面初次渲染完成
	 */
	onReady: function () {

	},

	/**
	 * 生命周期函数--监听页面显示
	 */
	onShow: function () {
		let that=this;
		let param={
			id:that.data.id
		}
		/**药品订单详情 drogOrderDetail()*/
		Service.drogOrderDetail(param).then((res)=>{
			console.log("res",res)
			let address={
				id:res.data.address,
				openid:wx.getStorageSync('data').openid,
				unionid:wx.getStorageSync('data').unionid,
				detail_address:res.data.detail_address,
				name:res.data.name,
				phone:res.data.phone,
				province:res.data.province,
				take_over:res.data.take_over,
				area:res.data.area,
				city:res.data.city,
			}
			if(res.code==1){
				that.setData({
					item:res.data,
					list:res.data.drug_arr,
					address:address
				})
			}
		}).catch(Error=>{
      console.warn('error:', Error); // 获取会话资料失败的相关信息
    });
	},

	/**
	 * 生命周期函数--监听页面隐藏
	 */
	onHide: function () {

	},

	/**
	 * 生命周期函数--监听页面卸载
	 */
	onUnload: function () {

	},

	/**
	 * 页面相关事件处理函数--监听用户下拉动作
	 */
	onPullDownRefresh: function () {

	},

	/**
	 * 页面上拉触底事件的处理函数
	 */
	onReachBottom: function () {

	},

	/**
	 * 用户点击右上角分享
	 */
	onShareAppMessage: function () {

	},
	/**复制 */
	copy(e) {
		let copy = e.currentTarget.dataset.c;
		wx.setClipboardData({
			data: copy,
			success: function (res) {
				wx.getClipboardData({
					success: function (res) {
						wx.showToast({
							title: '复制成功',
						})
					}
				})
			}
		})
	},
	//客服电话
	dial() {
		let tel = "4001199218";
		wx.makePhoneCall({
			phoneNumber: tel,
		})
	},
	/**打开常见问题 */
	issue(e){
		let that=this;
		let index=e.currentTarget.dataset.index;
		if(index==that.data.index){
			index=0;
		}
		that.setData({
			index:index
		})
	},
	/**
 *修改地址-待发货2
 */
editAddress:Util.debouce(function (e) {
	Service.isEditAddress({
		ordernumber: e.currentTarget.dataset.ordernumber
	}).then((res) => {
		if (res.code == 1) {
			wx.navigateTo({
				url: '/packageA/addsite/addsite?item=' +JSON.stringify(e.currentTarget.dataset.address)+'&ordernumber='+e.currentTarget.dataset.ordernumber,
			})
		}else{
			wx.showToast({
				title: res.msg,
				icon: 'success',
				mask: true
			})
		}
	})
}, 1000, true),


  /**
   * 查看处方
   * type 0 处方 1 用药建议
   * @param {} e 
   */
  viewRecipe(e) {
    let item = e.currentTarget.dataset.item;
    wx.navigateTo({
      url: '/packageA/recipeDetails/recipeDetails?id=' + item.id + '&type=0',
    })
	},
		//查看物流-待收货+已完成
		goLogistics: Util.debouce(function (e) {
			wx.navigateTo({
				url: e.currentTarget.dataset.src + "?num=" + e.currentTarget.dataset.num + '&tel=' + e.currentTarget.dataset.tel + '&ordernumber=' + e.currentTarget.dataset.ordernumber + '&img=' + e.currentTarget.dataset.img + '&status=' + e.currentTarget.dataset.status+'&com='+e.currentTarget.dataset.com+'&address='+JSON.stringify(e.currentTarget.dataset.address),
			})
		},1000,true),
})