var Service = require('../../utils/service.js');
var Util = require('../../utils/util.js');
Page({
	/**
	 * 页面的初始数据
	 */
	data: {
		errorToptips: '',
		items: [{
				name: '男',
				value: '男',
				checked: 'true'
			},
			{
				name: '女',
				value: '女',
			}
		],
		idTypeArr: ['身份证', '非中国大陆居民'],
		idType: 0,
		date: '请选择',
		agree: true, //同意知情书
		name: "",
		sex: '男',
		age: '请选择',
		phone: '',
		code: '',
		lastid: '',
		ServicePay_datas: '',
		t_userInfo: '',
		serviceName: '',
		time: 0,
		phoneYes: false,
		iPhoneX: false,
		backCode: '',
		backPhone: '',
		weight: '',
		SEXstate: 0,
		idCard: '',
		GMSLength: 0,
		GMStext: "",
		GWBSLength: 0,
		GWBStext: "",
		GMSstate: 0,
		GWBSstate: 0,
		GGNstate: 0,
		SGNstate: 0,
		BYQKstate: 0,
		id: '',
		needIdCard: 0,
		lock: false,
		sava: true
	},
	/**
	 * 生命周期函数--监听页面加载
	 * item 用户信息
	 * needIdCard 是否必填
	 */
	onLoad: function (options) {
		let that = this;
		let timestamp = (new Date()).valueOf();
		that.setData({
			endTime: Util.timestampToTime(timestamp),
			noIdCard: options.noIdCard
		})
		console.log("options", options)
		if (options.needIdCard) {
			that.setData({
				needIdCard: options.needIdCard
			})
		}
		if (!Util.isEmpty(options.item)) {
			let item = JSON.parse(options.item);
			console.log("item", item)
			that.setData({
				id: item.id,
				name: item.name,
				phone: item.phone,
				idCard: item.card,
				idType: item.idtype,
				lock: item.card.length > 0 && item.idtype == 0 ? true : false,
				SEXstate: item.sex == '男' ? 0 : 1,
				age: item.age,
				date: item.birthday,
				weight: item.weight,
				GMSLength: Util.isEmpty(item.allergy_desc) ? 0 : item.allergy_desc.length,
				GMStext: item.allergy_desc,
				GWBSLength: Util.isEmpty(item.past_desc) ? 0 : item.past_desc.length,
				GWBStext: item.past_desc,
				GMSstate: item.allergy,
				GWBSstate: item.past,
				GGNstate: item.liver,
				SGNstate: item.kidney,
				BYQKstate: item.beiyun,
				nodel: item.nodel ? item.nodel : 0 //是否允许删除
			})
		}
	},
	bindDateChange: function (e) {
		var age = Util.getAge(e.detail.value)
		this.setData({
			date: e.detail.value,
			age: age
		})
	},
	/**
	 * 生命周期函数--监听页面初次渲染完成
	 */
	onReady: function () {

	},
	/**手机号输入 */
	bindPhone: function (e) {
		this.setData({
			phone: e.detail.value
		})
		if (e.detail.value.length == 11) {
			this.setData({
				phoneYes: true
			})
		} else if (e.detail.value.length == 0) {
			this.setData({
				phoneYes: false
			})
		}
	},
	bindIdType(e) {
		this.setData({
			idType: e.detail.value,
			lock: e.detail.value = 1 ? false : this.data.lock
		})
	},
	//微信获取手机号 add lq dateTime 2020-03-23 
	getPhoneNumber(e) {
		let that = this;
		var user = wx.getStorageSync('user')
		var data = {
			openid: user.openid,
			encryptedData: e.detail.encryptedData,
			iv: e.detail.iv,
			session_key: user.session_key
		}
		Service.getWxUserPhone(data).then((res) => {
			if (res.code == 1) {
				that.setData({
					phone: res.data,
				});
			} else {
				that.setData({
					errorToptips: '获取失败，请重新获取'
				})
			}
		}).catch(err => {
			console.error("获取手机号", err)
		})
	},
	/**获取验证码 */
	bindCode: function (e) {
		this.setData({
			code: e.detail.value
		})
	},
	//获取验证码 add lq dateTime 2020-04-10 
	getPhoneCode() {
		var that = this;
		// 开始倒计时
		that.setData({
			time: 60,
			timer: setInterval(function () {
				let time = that.data.time
				that.setData({
					time: time - 1
				})
				if (that.data.time == 0) {
					// 读秒结束 清空计时器
					clearInterval(that.data.timer);
				}
			}, 1000)
		})

		var data = {
			tel: that.data.phone,
			type: 1
		}
		Service.getCode(data).then((res) => {
			that.setData({
				backCode: res.code,
				backPhone: that.data.phone
			})
		});
	},
	bindIdCard(e) {
		var that = this;
		that.setData({
			idCard: e.detail.value.trim(),
		})
		if (Util.validateIdCard(e.detail.value.trim()) && that.data.idType == 0) {
			var date = Util.getBirthdayFromIdCard(e.detail.value.trim());
			var age = Util.getAge(date)
			var SEXstate = Util.getSexFromIdCard(e.detail.value.trim())
			console.log(SEXstate);
			that.setData({
				date: date,
				age: age,
				SEXstate: SEXstate,
				lock: true
			})
		} else {
			that.setData({
				lock: false
			})
		}
	},
	selectBtn: function (e) {
		var that = this;
		console.log(e)
		switch (e.currentTarget.dataset.type) {
			case 'GMS':
				that.setData({
					GMSstate: e.currentTarget.dataset.state
				})
				break;
			case 'GWBS':
				that.setData({
					GWBSstate: e.currentTarget.dataset.state
				})
				break;
			case 'GGN':
				that.setData({
					GGNstate: e.currentTarget.dataset.state
				})
				break;
			case 'SGN':
				that.setData({
					SGNstate: e.currentTarget.dataset.state
				})
				break;
			case 'man':
				that.setData({
					SEXstate: e.currentTarget.dataset.state
				})
				break;
			case 'woman':
				that.setData({
					SEXstate: e.currentTarget.dataset.state
				})
				break;
			case 'BYQK':
				that.setData({
					BYQKstate: e.currentTarget.dataset.state
				})
				break;
		}
	},
	bindGMS(e) {
		this.setData({
			GMStext: e.detail.value,
			GMSLength: e.detail.value.length
		})
	},
	bindGWBS(e) {
		this.setData({
			GWBStext: e.detail.value,
			GWBSLength: e.detail.value.length
		})
	},
	bindName(e) {
		this.data.name = e.detail.value;
	},
	bindWeight(e) {
		this.data.weight = e.detail.value;
	},
	//保存
	sava: Util.debouce(function () {
		var that = this;
		if (that.data.name == "") {
			wx.showModal({
				title: '提示',
				content: '请填写正确的姓名',
				showCancel: false,
			})
			return;
		} else if (that.data.phone != '' && that.data.phone.length != 11) {
			wx.showModal({
				title: '提示',
				content: '请填写正确的手机号',
				showCancel: false,
			})
			that.setData({
				sava: true
			})
			return;
		} else if (that.data.phoneYes && that.data.backPhone == '') {
			wx.showModal({
				title: '提示',
				content: '请填写正确的验证码',
				showCancel: false,
			})
			that.setData({
				sava: true
			})
			return;
		} else if (that.data.phoneYes && that.data.phone != that.data.backPhone) {
			wx.showModal({
				title: '提示',
				content: '填写的手机号与获取验证码手机号不符',
				showCancel: false,
			})
			that.setData({
				sava: true
			})
			return;
		} else if (that.data.phoneYes && (that.data.code.length < 4 || that.data.code != that.data.backCode)) {
			wx.showModal({
				title: '提示',
				content: '请填写正确的验证码',
				showCancel: false,
			})
			that.setData({
				sava: true
			})
			return;
		} else if (that.data.idCard == '' && that.data.needIdCard == 1) {
			wx.showModal({
				title: '提示',
				content: '请填写正确的身份证号',
				showCancel: false,
			})
			that.setData({
				sava: true
			})
			return;
		} else if (!Util.validateIdCard(that.data.idCard) && that.data.idType == 0 && that.data.idCard != '') {
			console.log(that.data.idCard);
			console.log(2)
			wx.showModal({
				title: '提示',
				content: '请填写正确的身份证号',
				showCancel: false,
			})
			that.setData({
				sava: true
			})
			return;
		} else if (that.data.date == "请选择") {
			wx.showModal({
				title: '提示',
				content: '请填写正确的出生年月',
				showCancel: false,
			})
			return;
		} else if (that.data.GMSstate == 1 && that.data.GMSLength == 0) {
			wx.showModal({
				title: '提示',
				content: '请填写过敏药物',
				showCancel: false,
			})
			return;
		} else if (that.data.GWBSstate == 1 && that.data.GWBSLength == 0) {
			wx.showModal({
				title: '提示',
				content: '请填写过往病史',
				showCancel: false,
			})
			return;
		} else if (that.data.idCard != '') {
			if (that.data.idType == 1 || that.data.idCard.substring(0, 2) == '65') {
				var allData = wx.getStorageSync("data");
				var data
				if (that.data.id == '') {
					data = {
						unionid: allData.unionid,
						name: that.data.name,
						phone: that.data.phone,
						age: that.data.age,
						card: that.data.idCard,
						idType: that.data.idType,
						sex: that.data.SEXstate == 0 ? '男' : '女',
						birthday: that.data.date,
						weight: that.data.weight,
						allergy: that.data.GMSstate,
						allergy_desc: that.data.GMStext,
						past: that.data.GWBSstate,
						past_desc: that.data.GWBStext,
						liver: that.data.GGNstate,
						kidney: that.data.SGNstate,
						beiyun: that.data.SEXstate == 1 ? that.data.BYQKstate : '0'
					}
					Service.addUserBuyInfo(data).then((res) => {
						if (res.code == 1) {
							if (that.data.needIdCard == 1) {
								var pages = getCurrentPages();
								var prevPage = pages[pages.length - 3]; //上上一个页面
								prevPage.setData({ // 这里是需要传递的参数值
									item: ''
								})
								wx.navigateBack({
									delta: 2
								})
								that.setData({
									sava: true
								})
							} else {
								wx.navigateBack({
									delta: 1
								})
								that.setData({
									sava: true
								})
							}
						} else {
							wx.showModal({
								title: '提示',
								content: res.msg,
								showCancel: false,
							})
							that.setData({
								sava: true
							})
						}
					})
				} else {
					data = {
						id: that.data.id,
						unionid: allData.unionid,
						name: that.data.name,
						phone: that.data.phone,
						age: that.data.age,
						card: that.data.idCard,
						idType: that.data.idType,
						sex: that.data.SEXstate == 0 ? '男' : '女',
						birthday: that.data.date,
						weight: that.data.weight,
						allergy: that.data.GMSstate,
						allergy_desc: that.data.GMStext,
						past: that.data.GWBSstate,
						past_desc: that.data.GWBStext,
						liver: that.data.GGNstate,
						kidney: that.data.SGNstate,
						beiyun: that.data.SEXstate == 1 ? that.data.BYQKstate : '0'
					}
					Service.editUserBuyInfo(data).then((res) => {
						if (res.code == 1) {
							if (that.data.needIdCard == 1) {
								var pages = getCurrentPages();
								var prevPage = pages[pages.length - 3]; //上上一个页面
								prevPage.setData({ // 这里是需要传递的参数值
									item: data
								})
								wx.navigateBack({
									delta: 2
								})
								that.setData({
									sava: true
								})
							} else {
								wx.navigateBack({
									delta: 1
								})
								that.setData({
									sava: true
								})
							}
						} else {
							wx.showModal({
								title: '提示',
								content: res.msg,
								showCancel: false,
							})
							that.setData({
								sava: true
							})
						}
					})
				}
			} else {
				Util.verifyIdCardAnName(that.data.name, that.data.idCard, res => {
					switch (res.code) {
						case 0:
							var allData = wx.getStorageSync("data");
							var data
							if (that.data.id == '') {
								data = {
									unionid: allData.unionid,
									name: that.data.name,
									phone: that.data.phone,
									age: that.data.age,
									card: that.data.idCard,
									idType: that.data.idType,
									sex: that.data.SEXstate == 0 ? '男' : '女',
									birthday: that.data.date,
									weight: that.data.weight,
									allergy: that.data.GMSstate,
									allergy_desc: that.data.GMStext,
									past: that.data.GWBSstate,
									past_desc: that.data.GWBStext,
									liver: that.data.GGNstate,
									kidney: that.data.SGNstate,
									beiyun: that.data.SEXstate == 1 ? that.data.BYQKstate : '0'
								}
								Service.addUserBuyInfo(data).then((res) => {
									if (res.code == 1) {
										if (that.data.needIdCard == 1) {
											var pages = getCurrentPages();
											var prevPage = pages[pages.length - 3]; //上上一个页面
											prevPage.setData({ // 这里是需要传递的参数值
												item: ''
											})
											wx.navigateBack({
												delta: 2
											})
											that.setData({
												sava: true
											})
										} else {
											wx.navigateBack({
												delta: 1
											})
											that.setData({
												sava: true
											})
										}
									} else {
										wx.showModal({
											title: '提示',
											content: res.msg,
											showCancel: false,
										})
										that.setData({
											sava: true
										})
									}
								})
							} else {
								data = {
									id: that.data.id,
									unionid: allData.unionid,
									name: that.data.name,
									phone: that.data.phone,
									age: that.data.age,
									card: that.data.idCard,
									idType: that.data.idType,
									sex: that.data.SEXstate == 0 ? '男' : '女',
									birthday: that.data.date,
									weight: that.data.weight,
									allergy: that.data.GMSstate,
									allergy_desc: that.data.GMStext,
									past: that.data.GWBSstate,
									past_desc: that.data.GWBStext,
									liver: that.data.GGNstate,
									kidney: that.data.SGNstate,
									beiyun: that.data.SEXstate == 1 ? that.data.BYQKstate : '0'
								}
								Service.editUserBuyInfo(data).then((res) => {
									if (res.code == 1) {
										if (that.data.needIdCard == 1) {
											var pages = getCurrentPages();
											var prevPage = pages[pages.length - 3]; //上上一个页面
											prevPage.setData({ // 这里是需要传递的参数值
												item: data
											})
											wx.navigateBack({
												delta: 2
											})
											that.setData({
												sava: true
											})
										} else {
											wx.navigateBack({
												delta: 1
											})
											that.setData({
												sava: true
											})
										}
									} else {
										wx.showModal({
											title: '提示',
											content: res.msg,
											showCancel: false,
										})
										that.setData({
											sava: true
										})
									}
								})
							}
							break;
						case 6000:
						case 6001:
						case 6002:
						case 6003:
						case 6004:
						case 6005:
							wx.showModal({
								title: '提示',
								content: res.msg,
								showCancel: false,
							})
							that.setData({
								sava: true
							})
							return;
					}
				})
			}
		} else {
			var allData = wx.getStorageSync("data");
			if (that.data.id == '') {
				var data = {
					unionid: allData.unionid,
					name: that.data.name,
					card: that.data.idCard,
					idType: that.data.idType,
					age: that.data.age,
					sex: that.data.SEXstate == 0 ? '男' : '女',
					birthday: that.data.date,
					phone: that.data.phone,
					weight: that.data.weight,
					allergy: that.data.GMSstate,
					allergy_desc: that.data.GMStext,
					past: that.data.GWBSstate,
					past_desc: that.data.GWBStext,
					liver: that.data.GGNstate,
					kidney: that.data.SGNstate,
					beiyun: that.data.SEXstate == 1 ? that.data.BYQKstate : '0'
				}
				Service.addUserBuyInfo(data).then((res) => {
					if (res.code == 1) {
						if (that.data.needIdCard == 1) {
							var pages = getCurrentPages();
							var prevPage = pages[pages.length - 3]; //上上一个页面
							prevPage.setData({ // 这里是需要传递的参数值
								item: data
							})
							wx.navigateBack({
								delta: 2
							})
							that.setData({
								sava: true
							})
						} else {
							wx.navigateBack({
								delta: 1
							})
							that.setData({
								sava: true
							})
						}
					} else {
						wx.showModal({
							title: '提示',
							content: res.msg,
							showCancel: false,
						})
						that.setData({
							sava: true
						})
					}
				}).catch(err => {
					console.log("addUserBuyInfo", err)
				})
			} else {
				var data = {
					id: that.data.id,
					unionid: allData.unionid,
					name: that.data.name,
					card: that.data.idCard,
					idType: that.data.idType,
					age: that.data.age,
					phone: that.data.phone,
					sex: that.data.SEXstate == 0 ? '男' : '女',
					birthday: that.data.date,
					weight: that.data.weight,
					allergy: that.data.GMSstate,
					allergy_desc: that.data.GMStext,
					past: that.data.GWBSstate,
					past_desc: that.data.GWBStext,
					liver: that.data.GGNstate,
					kidney: that.data.SGNstate,
					beiyun: that.data.SEXstate == 1 ? that.data.BYQKstate : '0'
				}
				Service.editUserBuyInfo(data).then((res) => {
					if (res.code == 1) {
						if (that.data.needIdCard == 1) {
							var pages = getCurrentPages();
							var prevPage = pages[pages.length - 3]; //上上一个页面
							prevPage.setData({ // 这里是需要传递的参数值
								item: data
							})
							wx.navigateBack({
								delta: 2
							})
							that.setData({
								sava: true
							})
						} else {
							wx.navigateBack({
								delta: 1
							})
							that.setData({
								sava: true
							})
						}
					} else {
						wx.showModal({
							title: '提示',
							content: res.msg,
							showCancel: false,
						})
						that.setData({
							sava: true
						})
					}
				}).catch(err => {
					console.log("editUserBuyInfo", err)
				})
			}
		}
	}, 1000, true),
	//删除
	del() {
		var that = this;
		wx.showModal({
			title: '提示',
			content: '确认删除此患者信息吗？',
			success(res) {
				if (res.confirm) {
					var data = {
						id: that.data.id
					}
					Service.delUserbuyInfo(data).then((res) => {
						if (res.code == 1) {
							wx.showToast({
								title: '删除成功',
								icon: 'none'
							})
							wx.navigateBack({
								delta: 1
							})
						} else {
							wx.showModal({
								title: '提示',
								content: res.msg,
								showCancel: false,
							})
						}
					})
				}
			}
		})
	}
})