const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');
Page({
	/**
	 * 页面的初始数据
	 */
	data: {
		list: {
			status: 3
		},
		id: '',
		iphonex: false,
		inquiry_id: '',
		time: '',
		time1: '',
		setInter: '',
		type:0
	},

	/**
	 * 生命周期函数--监听页面加载
	 */
	onLoad: function (options) {
		var that = this
		that.checkModal();
		that.data.id = options.id;
		that.setData({
			type:options.type
		})
		that.data.inquiry_id = Util.isEmpty(options.inquiry_id) ? "" : options.inquiry_id;
		wx.setNavigationBarTitle({
      title: options.type=='1'?"医生建议":"处方建议"
		})
		that.getDrugDetail();
	},
	/**
	 * 生命周期函数--监听页面显示
	 */
	onShow: function () {
		var that = this
		that.data.setInter = setInterval(function () {
			var yourtime = that.data.time;
			yourtime = yourtime.replace("-", "/"); //替换字符，变成标准格式  
			var d2 = new Date(); //取今天的日期  
			var d1 = new Date(Date.parse(yourtime));
			if (d1 > d2) {
				that.setData({
					time1: that.showtime()
				})
			} else {
				that.setData({
					time1: '00:00:00'
				})
				that.onShow();
				clearInterval(that.data.setInter)
			}
		}, 1000);
	},
	getDrugDetail() {
		let that = this;
		var data = {
			id: that.data.id,
			inquiry_id: that.data.inquiry_id
		};
		Service.getDrugDetail(data).then((res) => {
			if (res.code == 1) {
				that.setData({
					list: res.data,
					id:that.data.id,
					inquiry_id: that.data.inquiry_id,
					time: res.data.preexpired_time
				})
			} else {
				wx.showModal({
					title: '提示',
					content: res.msg,
					showCancel: false,
					success(res) {
						if (res.confirm) {
							wx.navigateBack({
								complete: (res) => {
									delta: 1
								},
							})
						}
					}
				})
			}
		})
	},
	showtime: function () {
		var nowtime = new Date()
		var regs = new RegExp('-', "g")
		var newstr = this.data.time.replace(regs, '/')
		var endtime = new Date(newstr); //定义结束时间
		var lefttime = endtime.getTime() - nowtime.getTime(), //距离结束时间的毫秒数
			leftd = Math.floor(lefttime / (1000 * 60 * 60 * 24)), //计算天数
			lefth = Math.floor(lefttime / (1000 * 60 * 60) % 24 + leftd * 24), //计算小时数
			leftm = Math.floor(lefttime / (1000 * 60) % 60), //计算分钟数
			lefts = Math.floor(lefttime / 1000 % 60); //计算秒数
		return (lefth.toString().length == '1' ? "0" + lefth : lefth) + ":" + (leftm.toString().length == '1' ? "0" + leftm : leftm) + ":" + (lefts.toString().length == '1' ? "0" + lefts : lefts) //返回倒计时的字符串
	},
	putDemand() {
		var that = this
		wx.navigateTo({
			url: '/packageA/drugOrderInfo/drugOrderInfo?scene=' + that.data.id + '&inquiry_id=' + that.data.inquiry_id + "&Pid=1",
		})
	},
	///查看订单
	seeOrder: function () {
		var that = this
		wx.navigateTo({
			url: '/packageA/drugOrder/drugOrder?status=' + that.data.list.drug_order_status,
		})
	},
	/**
	 * 生命周期函数--监听页面隐藏
	 */
	onHide: function () {
		clearInterval(this.data.setInter)
	},
	/**
	 * 生命周期函数--监听页面卸载
	 */
	onUnload: function () {
		clearInterval(this.data.setInter)
	},
	//判断是否是iPhonex
	checkModal: function () {
		let that = this;
		wx.getSystemInfo({
			success: (res) => {
				// iPhone X   iPhone XR  iPhone XS Max     iPhone XS
				if (/^iPhone X.*/i.test(res.model) || /^iPhone XR.*/i.test(res.model) || /^iPhone XS.*/i.test(res.model) || /^iPhone 11*/i.test(res.model) || /^iPhone 11 Pro Max*/i.test(res.model)) {
					that.setData({
						iPhoneX: true,
					})
				} else {
					that.setData({
						iPhoneX: false,
					})
				}
			}
		});
	},
})