var Service = require('../../utils/service.js');
var Util = require('../../utils/util.js');
Page({
  /**
   * 页面的初始数据
   */
  data: {
    iPhoneX: false,
    iShow: 0,
    id: '',
    needIdCard: 0,
    noIdCard: 0 //显示
  },
  /**
   *  生命周期函数--监听页面加载
   * @param {options.type}  进入途径1：购买服务，2：购买药物（）身份证必填，3：医生列表
   * @param {options.iShow} type=2||3 有选中id
   * @param {options.item}  type=2||3  有选中对象
   */
  onLoad: function (options) {
    console.log("options", options)
    var that = this;
    that.setData({
      type: options.type
    })
    if (!Util.isEmpty(options.noIdCard)) {
      that.data.noIdCard = options.noIdCard;
    }
    if (options.type == 2) {
      that.data.needIdCard = 1;
    } else if (options.type == 3) {
      that.data.t_unionid = options.t_unionid;
    }
    if(!Util.isEmpty(options.iShow)) {
      that.data.iShow = options.iShow;
      that.data.item =options.item?JSON.parse(options.item):{};
    }
    that.checkModal();
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.hideLoading({})
    this.getUserList();
  },
  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },
  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },
  getUserList() {
    var that = this;
    console.log("getUserList")
    var allData = wx.getStorageSync('data')
    var data = {
      unionid: allData.unionid
    }
    Service.userBuyInfoList(data).then((res) => {
      if (res.code == 1) {
        if (res.data.length > 0) {
          if (that.data.type != 1) {
            let item = that.data.item
            that.setData({
              iShow: that.data.iShow == 0 ? res.data[0].id : that.data.iShow,
              item: that.data.iShow == 0 ? res.data[0] : item
            })
          } else {
            if (that.data.iShow != 0) {
              let item = res.data.find((value) => value.id == that.data.iShow)
              that.setData({
                item: item
              })
              console.log("item", item)
            }
          }
        }
        that.setData({
          infoList: res.data
        })
      }
    })
  },
  switch: function (e) {
    this.setData({
      iShow: e.currentTarget.dataset.id,
      item: e.currentTarget.dataset.item
    })
  },
  myDetails: function (e) {
    console.log("this.data.needIdCard", this.data.needIdCard)
    wx.navigateTo({
      url: e.currentTarget.dataset.src + "?needIdCard=" + this.data.needIdCard + '&noIdCard=' + this.data.noIdCard,
    })
  },
  checkModal: function () {
    let that = this;
    wx.getSystemInfo({
      success: (res) => {
        // iPhone X   iPhone XR  iPhone XS Max     iPhone XS
        if (/^iPhone X.*/i.test(res.model) || /^iPhone XR.*/i.test(res.model) || /^iPhone XS.*/i.test(res.model) || /^iPhone 11*/i.test(res.model) || /^iPhone 11 Pro Max*/i.test(res.model)) {
          that.setData({
            iPhoneX: true,
          })
        } else {
          that.setData({
            iPhoneX: false,
          })
        }
      }
    });
  },
  next:Util.debouce(function (e){
    wx.showLoading();
    var that = this;
    if (Util.isEmpty(that.data.item)) {
      wx.showModal({
        content: "请选择或添加患者信息",
        showCancel: false,
      })
      wx.hideLoading();
      return
    } else if (that.data.needIdCard == 1 && that.data.item.card == "") {
      wx.showModal({
        title: '提示',
        content: '请选择填写过身份证的患者',
        showCancel: false,
      })
      wx.hideLoading();
      return;
    }
    if (that.data.type == 1 || that.data.type == 2) {
      var pages = getCurrentPages();
      var prevPage = pages[pages.length - 2]; //上一个页面
      prevPage.setData({ // 这里是需要传递的参数值
        item: that.data.item
      })
      wx.navigateBack({
        delta: 1
      })
      wx.hideLoading();
    } else {
      var allData = wx.getStorageSync('data')
      let data = {
        user: that.data.iShow,
        add_unionid: that.data.t_unionid,
        unionid: allData.unionid
      }      
      let data1 = {
        id: that.data.iShow,
        consultant_unionid: that.data.t_unionid,
        patient_unionid: allData.unionid
      }
      Service.sendCard(data1).then(()=>{
        return Service.firendAfterRoom(data)
      }).then((res) => {
        console.log("firendAfterRoom",res)
        wx.reLaunch({
          url: '../chat/chat?t_unionid=' + that.data.t_unionid + '&groupID=' + res.chat_id,
        })
        wx.hideLoading();
      })
    }
  },1000,true),
  editInfo:Util.debouce(function(e) {
    console.log(this.data.needIdCard)
    wx.navigateTo({
      url: "../editUser/editUser?item=" + JSON.stringify(e.currentTarget.dataset.item) + "&needIdCard=" + this.data.needIdCard + '&noIdCard=' + this.data.noIdCard,
    })
  },1000,true)
})