const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');
Page({
  /**
   * 页面的初始数据
   */
  data: {
    rechargeList: '',
    noRecord: {
      winH: null,
    },
    ishow: false
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    wx.getSystemInfo({
      success: (res) => {
        this.setData({
          ['noRecord.winH']: res.windowHeight
        })
      }
    })
  },
  onShow() {
    this.getFollowUpList();
  },
  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {
    this.getFollowUpList()
  },
  /**预约记录 */
  getFollowUpList() {
    var data = {
      patient_unionid:wx.getStorageSync('data').unionid
    };
    Service.getFollowUpList(data).then((res)=>{
      if (res.code == 1) {
        this.setData({
          rechargeList: res.data,
          ishow: true,
        })
        wx.stopPullDownRefresh()
      }
    })
  },
  connect(e) {
    var that=this;
    if (that.data.confirm) {
      return;
    }
    that.data.confirm = true
    let t_unionid = e.currentTarget.dataset.t_unionid;
    wx.navigateTo({
      url: '/packageA/chat/chat?type=0&t_unionid=' + t_unionid,
    })
    that.data.confirm=false;
  },
})