const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');
Page({

  /**
   * 页面的初始数据
   */
  data: {
    error: '',
    qy: false,
    hidden: true,
    money: 0,
    btnFlag: 0, //提交按钮状态 0 可提交   1不可提交
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    let that = this
    let gid = options.gid
    let money = options.money
    let descs = options.descs
    that.setData({
      gid: gid,
      money: money,
      descs: descs
    })
    let data = {}
    data.openid = wx.getStorageSync('data').openid;
    Service.getInvoiceInfo(data).then((res)=>{
      if (res.data != null) {
        // let qy = res.data.qy_type == 0 ? true : false
        that.setData({
          // qy: qy,
          tickValue: res.data.ghdwmc,
          taxpayerValue: res.data.ghdwsbh,
          emailValue: res.data.qy_email
        })
      }
    })
  },
   /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {
      //获得modal组件
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  cancel() {
    this.setData({
      hidden: true
    })
  },
  confirm() {
    let that = this
    that.setData({
      hidden: true,  // 隐藏弹窗
      btnFlag: 1,//改变按钮点击状态
    })

    let gid = that.data.gid
    wx.showLoading({
      title: '正在提交',
    })
    Service.sendEmail(gid).then(()=>{
      wx.navigateTo({
        url: '../invoiceprompt/invoiceprompt?qq=' + that.data.emailValue + '&gid=' + gid,
      })
      wx.hideLoading()
    })
  },
  goPer(){
    this.setData({
      qy:true
    })
  },
  goQi() {
    this.setData({
      qy: false
    })
  },
  // 发票抬头
  titckInput(e) {
    let tickValue = e.detail.value;
    this.setData({
      tickValue: tickValue
    })
    if(e.detail.value.length==0){
      this.setData({
        taxpayerValue: ""
      })
    }
  },
  
  // 纳税人识别号失去焦点
  taxpayerBlur(e){
    let taxpayerValue = e.detail.value;
      this.setData({
        taxpayerValue: taxpayerValue
      })
  },
  emailInput(e){
    let emailValue = e.detail.value;
      this.setData({
        emailValue: emailValue
      })
  },
  // 电子邮箱失去焦点
  emailBlur(e){
    let value = e.detail.value;
    let regexp = /^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
    var emailValue = '';
    if (!regexp.test(value)){
      Util.alert('请输入正确的邮箱');
      emailValue = '';
    }else{
      emailValue = value;
    }
    this.setData({
      emailValue: emailValue
    })
  },
  partyone(e) {
    let tickValue = e.detail.value;
    this.setData({
      tickValue: tickValue
    })
  },
  goBtn() {
    let that = this;
    let otype = (this.data.qy) ? '0' : '1';
    let gid = this.data.gid;
    let money = this.data.money;
    let qy = this.data.qy;
    let hidden = this.data.hidden
    let continer = this.data.descs;
    // 判断是企业开票还是个人开票
    if (qy) {
      // 判断发票信息是否完善
      if (this.data.tickValue && this.data.taxpayerValue && this.data.emailValue) {
        let openid = wx.getStorageSync('data').openid;
        let data = {};
        data.type = otype;
        data.g_id = gid;
        data.money = money;
        data.openid = openid;
        data.tickValue = that.data.tickValue;
        data.taxpayerValue = that.data.taxpayerValue;
        data.emailValue = that.data.emailValue;
        data.continer = continer;
        Service.saveInvoiceInfo(data).then(()=>{})
        hidden = false
      } else {
        hidden = true
        Util.alert('请填写完整的发票信息')
      }
    } else {
      // 个人开票，判断信息是否完善
      if (this.data.emailValue && this.data.tickValue) {
        let openid = wx.getStorageSync('user').openid;
        let data = {};
        data.type = otype;
        data.g_id = gid;
        data.money = money;
        data.openid = openid;
        data.tickValue = that.data.tickValue;
        data.taxpayerValue = '';
        data.emailValue = that.data.emailValue;
        data.continer = continer;
        Service.saveInvoiceInfo(data).then(()=>{})
        hidden = false
      } else {
        hidden = true
        Util.alert('请填写完整的发票信息')
      }
    }
    // 控制model组件的显示与隐藏
    console.log("hidden",hidden)
    this.setData({
      hidden: hidden
    })
  },
  titckConfirm() {
    var that = this;
    if(that.data.titckConfirm)return;
    that.data.titckConfirm=true;
    var allData = wx.getStorageSync('data');
    var data = {
      keyword: that.data.tickValue,
      openid: allData.openid,
    }
   Service.getTaxpayers(data).then((res)=>{
     console.log(res)
      if (res.code == 1) {
        that.setData({
          taxpayerValue: res.data,
          titckConfirm:false
        })
      } else {
        that.setData({
          error:res.msg,
          titckConfirm:false
        })
 
      }
    })
  },
  _confirmEvent() {
    console.log('你点击了确定');
    // this.modal.hideModal();
  },
})