// packageA/logistics/logistics.js
const Api = require('../../utils/api.js');
var Service = require('../../utils/service.js');
const util = require('../../utils/util.js');
Page({

	/**
	 * 页面的初始数据
	 */
	data: {
		active: 0,
		arr: [],
		list: [],
		time: '',
		time2: '',
		time3: '',
		img: '',
		status: '',
		logistics: false,
		mobileTail: '',
		xdorderid: ''
	},
	/**
	 * 生命周期函数--监听页面加载
	 */
	onLoad: function (options) {
		let that = this
		that.setData({
			img: options.img,
			status: options.status,
			address: JSON.parse(options.address)
		})
		if (options.tel) {
			that.setData({
				mobileTail: options.tel.substring(options.tel.length - 4),
			})
		}
		console.log("options",options)
		var list = options.num.split(',')
		var comlist = options.com.split(',')
		that.setData({
			xdorderid: options.ordernumber,
			list: list,
			orderid: list[0],
			comlist: comlist,
			com: util.isEmpty(comlist[0]) ? 'shunfeng' : comlist[0]
		})
		that.getWl()
	},
	/**
	 * 生命周期函数--监听页面显示
	 */
	onShow: function () {

	},

	getWl: function () {
		var that = this
		var data = {}
		data.orderid = that.data.orderid;
		data.mobileTail = that.data.mobileTail;
		data.xdorderid = that.data.xdorderid;
		data.com = that.data.com;
		data.phone = that.data.mobileTail;
		Service.logisticsInfo(data).then((res) => {
			if (res.data) {
				that.setData({
					arr: res.data.orderRoute.reverse(),
					time: res.data.create_time,
					time2: res.data.pcreate_time,
					time3: res.data.create_time_two,
					time4: res.data.drug_send_time,
					logistics: true
				})
			}
		})
	},
	getSf: function (e) {
		var _this = this
		_this.setData({
			orderid: e.currentTarget.dataset.num
		})
		_this.getWl()
	},
	getNum: function (e) {
		wx.setClipboardData({
			data: this.data.orderid,
			success: function (res) {

			}
		})
	},
	ddh: function () {
		wx.makePhoneCall({
			phoneNumber: '95338' //仅为示例，并非真实的电话号码
		})
	},
})