var Service = require('../../utils/service.js');
Page({

	/**
	 * 页面的初始数据
	 */
	data: {
		noRecord: {
			winH: null,
		},
		listUser: '',
		iPhoneX: false,
		showview: false
	},


	/**
	 * 生命周期函数--监听页面加载
	 */
	onLoad: function (options) {
		this.checkModal();
	},

	/**
	 * 生命周期函数--监听页面初次渲染完成
	 */
	onReady: function () {
	},

	/**
	 * 生命周期函数--监听页面显示
	 */
	onShow: function () {
		var that = this;
		that.login = that.selectComponent("#login");
    that.modal = that.selectComponent("#modal");
    that.answer = that.selectComponent("#answer");
    wx.login({
      success: function (msg) {
        Service.getOpenId(msg.code).then((res) => {
          wx.setStorageSync('user', res)
          return Service.getUserData(res.openid)
        }).then((res) => {
          wx.setStorageSync('data', res) 
        })
      }
    })
		this.getListUser();
	},
	/**
	 * 用户点击右上角分享
	 */
	onShareAppMessage: function (res) {
    return {
      title: '请完善信息',
      path: 'packageA/patientList/patientList',
    }
	},//判断是否是iPhonex
	checkModal() {
		let that = this;
		wx.getSystemInfo({
			success: (res) => {
				// iPhone X   iPhone XR  iPhone XS Max     iPhone XS
				if (/^iPhone X.*/i.test(res.model) || /^iPhone XR.*/i.test(res.model) || /^iPhone XS.*/i.test(res.model) || /^iPhone 11*/i.test(res.model) || /^iPhone 11 Pro Max*/i.test(res.model)) {
					that.setData({
						iPhoneX: true,
						['noRecord.winH']: res.windowHeight - 120,
					})
				} else {
					that.setData({
						iPhoneX: false,
						['noRecord.winH']: res.windowHeight - 85,
					})
				}
			}
		});
	},
	///获取listUSer add lq dateTime 2020-03-23
	getListUser: function () {
		var that = this;
		var alldata = wx.getStorageSync('data')
		var data = {
			unionid: alldata.unionid
		}
		Service.userBuyInfoList(data).then((res) => {
			if (res.code == 1) {
				that.setData({
					listUser: res.data,
					showview: true
				})
			}
		}).catch(err=>{
			console.log("userBuyInfoList",err)
		})
	},
	///新增用户信息 add lq dateTime 2020-03-23
	addUser: function (e) {
		wx.navigateTo({
			url: "/packageA/editUser/editUser?btid=''",
		})
	},
	
	//修改
	navto: function (e) {
		console.log(e.currentTarget.dataset.item)
		wx.navigateTo({
			url: "/packageA/editUser/editUser?item=" + JSON.stringify(e.currentTarget.dataset.item) + "&btid=''",
		})
	},
	  //登陆后组件回调方法刷新当前页面
		_refreshEvent() {
			console.log("刷新");
			this.onShow();
		},
})