const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');
Page({

  /**
   * 页面的初始数据
   */
  data: {
    info: []
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    let that = this;
    that.setData({
      item: JSON.parse(options.item)
    })
    that.getServiceDetail(options.id)
  },
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {},

  getServiceDetail(id) {
    let that = this;
    Service.serviceDetail(id).then((res) => {
      if (res.code == 1) {
        that.setData({
          info: res.data,
        })
      }
    })
  },
  connect: Util.debouce(function () {
    var that = this;
    let t_unionid = this.data.info.consultant_unionid;
    let data = {};
    data.unionid = t_unionid;
    Service.getChatDoctor(data).then((res) => {
      if (res.code == 1) {
        if (that.data.info.status < 2) {
          that.switchService(that.data.info);
        }
        wx.navigateTo({
          url: '/packageA/chat/chat?t_unionid=' + t_unionid + "&groupID=" + that.data.item.chat_home,
        })
      }
    })
    // console.log('咨询师联系用户', openid)
  }, 1000, true),
  //重新购买
  repurchase: function () {
    wx.showLoading({mask:true});
    var op_openid = '';
    var data = {};
    data.unionid = this.data.info.consultant_unionid;
    Service.seeOpenId(data).then((res) => {
      if (res.code == 1) {
        op_openid = res.data.openid;
      }
    })
    var counsel = this.data.info.counsel < 16 ? 18 : this.data.info.counsel;
    wx.navigateTo({
      url: '/pages/docuterInfo/docuterInfo?t_unionid=' + this.data.info.consultant_unionid + '&t_unitid=' + this.data.info.unitid + '&t_openid=' + op_openid + '&counsel=' + counsel,
    })
    wx.hideLoading();
  },
  /**
   * 聊天记录
   */
  chatLog: Util.debouce(function () {
    wx.navigateTo({
      url: '/packageA/chattingRecords/chattingRecords?id=' + this.data.item.id + '&doctorimage=' + this.data.item.image,
    })
  }, 1000, true),
  //切换服务
  switchService:Util.debouce(function (item) {
    var alldata = wx.getStorageSync('data');
    var data = {
      patient_unionid: alldata.unionid,
      consultant_unionid: item.consultant_unionid,
      counsel: item.counsel,
      relation_id: item.id
    }
    Service.switchService(data).then((res) => {
      console.log("res", res)
    })
  },1000,true)
})