const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');
Page({

  /**
   * 页面的初始数据
   */
  data: {

  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    let qq = options.qq;
    let gid = options.gid;
    this.setData({
      email: qq,
      gid: gid
    })
    wx.setNavigationBarTitle({
      title: '电子发票详情',
    })
  },
    /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },
  changeCon(e){
    this.setData({
      email: e.detail.value
    })
  },
  del(){
    this.setData({
      email: ''
    })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },
  submit(){
    let that = this;
    let data = {}
    data.g_id = this.data.gid;
    wx.showLoading({
      title: '正在提交',
      mask:true
    })
    data.email = this.data.email;
    if (this.data.gid.length < 1 || this.data.email.length < 1){
      wx.hideLoading()
      wx.showToast({
        title: '信息不完整，请返回上一步重新提交',
        icon: 'none',
        duration: 1000
      })  
      return;
    }else{
      Service.editAgainEmail(data).then(()=>{
        console.log()
        wx.hideLoading()
        wx.navigateTo({
          url: '../invoiceprompt/invoiceprompt?qq=' + that.data.email + '&gid=' + that.data.gid,
        })
      })
    }
  },
})