// pages/fpdetail/fpdetail.js
const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');
const Config =require('../../utils/config.js');
Page({

  /**
   * 页面的初始数据
   */
  data: {
    hidden: true,
    maskshow: true,
    bornTime: '',
    returnmsg: '',
    pdfurl: ''
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    wx.showLoading({
      title: '加载中',
      mask:true
    })
    let that = this;
    let gid = options.gid;
    that.setData({
      gid: gid,
    });
    let data = {
      g_id: gid
    };
    that.getInvoiceDetail(data);
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
  },
  //发票详情
  getInvoiceDetail: function (data) {
    var that = this;
    Service.getInvoiceDetail(data).then((res) => {
      if (res) {
        that.setData({
          // returncode: 2,  //发票状态码
          returncode: res.body.returncode, //发票状态码
          bornTime: res.body.kprq || '',
          returnmsg: res.body.returnmsg || '',
          pdfurl: res.body.pdfurl || '', //发票PDF地址
          continer: res.info.spmc, //发票内容
          otype: res.info.type, //开发票的身份
          email: res.info.qy_email, //发票的邮箱地址
          taxId: res.info.ghdwsbh, //发票的税号
          money: res.info.jshj, //发票的开具金额
          create_time: res.info.create_time, //发票的申请时间
          mainBody: res.info.ghdwmc, //发票主体
          isrecharge: res.info.isrecharge, //  0  支付开票，1充值开票
          createtime: res.info.createtime, //检查时间 
          ordernumber: res.info.ordernumber, //订单编号
        })
        wx.hideLoading()
        that.setData({
          maskshow: false
        })
      }
    })
  },
  // 重新开票
  againTicket() {
    let that = this;
    wx.showModal({
      cancelText: '取消',
      confirmText: '重新开票',
      content: '是否确认重新开票',
      success: function (res) {
        if (res.confirm) {
          // that.sendEmail()
          wx.navigateTo({
            url: '../invoiceInfo/invoiceInfo?money=' + that.data.money + '&gid=' + that.data.gid + '&descs=' + that.data.continer,
          })
        }
      }
    })

  },
  // 等待发送邮件
  sendEmail() {
    let gid = this.data.gid
    let data = {}
    data.g_id = gid
    Service.sureEmail(data).then(() => {})
  },
  // 重发发票
  repeatSend() {
    let gid = this.data.gid
    wx.navigateTo({
      url: '../enterEmial/enterEmial?qq=' + this.data.email + '&gid=' + gid,
    })
  },

  /* 查看发票 */
  vieTicket() {
    let that = this;
    wx.showLoading({
      title: '加载中',
      mask:true
    })
    let gid = this.data.gid;
    Service.seeInvoice(gid).then((res)=>{
      wx.hideLoading();
      if (res) {
        let host = Config.HOST
        let pdfurl = that.dealPho(res.url, host)
        console.log("pdfurl",pdfurl)
        wx.downloadFile({
          url: pdfurl,
          success: function (res) {
            var filePath = res.tempFilePath
            wx.openDocument({
              filePath: filePath,
              success: function (res) {},
              fail: function (res) {}
            })
          }
        })
      }
    })

  },

  /* 图片地址处理 */
  dealPho(str, host) {
    return str.replace("./", host);
  },

  goDetail() {
    this.setData({
      hidden: false
    })
  },
  cancel() {
    this.setData({
      hidden: true
    })
  },
  confirm() {
    this.setData({
      hidden: true
    })
  },
  // 修改邮箱
  changeEamil: function (e) {
    this.setData({
      email: e.detail.value
    })
  },
  // 拨打电话
  telHandle() {
    Util.call('4001199218')
  },
})