const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');
const app = getApp();
Page({
  data: {
    list: [], //页面数据展现
    userInfo: "", //用户信息
  },
  onLoad: function () {
    let that = this;
  },
  onShow: function () {
    app.forcedUpdate();
    let that = this;
    //首页数据
    wx.login({
      success: function (msg) {
        Service.getOpenId(msg.code).then((res) => {
          wx.setStorageSync('user', res);
          return Service.getUserData(res.openid);
        }).then((res) => {
          wx.setStorageSync('data', res)
          that.setData({
            userInfo: res
          })
          // that.resultNot(res.openid);
        }).catch(error => {
          console.error("首页数据err", error)
        })
      }
    })
    that.getDoctorIndex();
  },
  onReady: function () {
    //获得modal组件
    this.modal = this.selectComponent("#modal");
    this.login = this.selectComponent("#login");
    this.answer = this.selectComponent("#answer");
  },
  //菜单栏红点提示
  resultNot(openid) {
    console.log("resultNot")
    //未做量表提醒await
    var data = {
      openid: openid
    }
    Service.getNotResult(data).then((res) => {
      if (res[0].length > 0) {
        wx.showTabBarRedDot({
          index: 2
        })
      } else {
        wx.hideTabBarRedDot({
          index: 2
        })
      }
    }).catch(error => {
      console.error("菜单栏红点提示", error)
    })
  },
  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {
    return {
      title: '小懂健康互联网医院',
      path: '/pages/index/index',
    }
  },
  onPullDownRefresh: function () {
    var that = this
    that.getDoctorIndex();
    that.resultNot(that.data.userInfo.openid)
    wx.stopPullDownRefresh();
  },
  ///特色门诊
  site: function (e) {
    wx.showLoading({mask:true})
    var that = this
    if (e.currentTarget.dataset.door) {
      that.nav('door', e.currentTarget.dataset.door)
    } else if (e.currentTarget.dataset.lcxl) {
      that.nav('lcxl', e.currentTarget.dataset.lcxl)
    } else if (e.currentTarget.dataset.shxl) {
      that.nav('shxl', e.currentTarget.dataset.shxl)
    } else {
      that.nav('page', '1')
    }
  },
  //跳转搜索页面
  nav(name, value) {
    wx.navigateTo({
      url: '/pages/search/search?' + name + '=' + value,
    })
    wx.hideLoading();
  },
  zys() {
    // wx.showToast({
    //   title: '该功能开发中',
    //   icon: 'none',
    //   duration: 2000,
    //   mask: true
    // })
  },
  //医生详情
  doctorInfo: function (e) {
    wx.showLoading({mask:true})
    //医生详情页
    wx.navigateTo({
      url: '/pages/docuterInfo/docuterInfo?t_unionid=' + e.currentTarget.dataset.unionid + '&t_unitid=' + e.currentTarget.dataset.unitid + '&t_openid=' + e.currentTarget.dataset.openid,
    })
    wx.hideLoading();
  },
  //医生数据
  getDoctorIndex() {
    var that = this
    Service.getDoctorIndex().then((res) => {
      that.setData({
        list: res.data
      })
    }).catch(error => {
      console.error("医生数据", error)
    })
  },
  /**
   * 图片加载失败函数
   * type 0 临床心理 1 社会心理
   * @param {any} e 
   */
  binderrorimg(e) {
    let type = e.currentTarget.dataset.type;
    let errorindex = e.currentTarget.dataset.errorindex;
    let up;
    if (type == 0) {
      up = "list.lcxl[" + errorindex + "].image";
    } else {
      up = "list.shxl[" + errorindex + "].image";
    }
    this.setData({
      [up]: '/images/doctor_img.png'
    })
  },
  // showDialog() {
  //   this.modal.showModal();
  //   this.modal.showCancel(false);
  // },
  // showDialog() {
  //   this.login.showLogin();
  // },
  // showDialog() {
  //   console.log('this.answer',this.answer)
  //   this.answer.showAnswer();
  // },
  //确认事件
  _cancelEvent() {
    console.log('你点击了取消');
    this.modal.hideModal();
  },
  //确认事件
  _confirmEvent() {
    console.log('你点击了确定');
    this.modal.hideModal();
  },

  _refreshEvent() {
    console.log("刷新");
    this.onShow();
  },
})