var Util = require('../../utils/util.js');
var Api = require('../../utils/api.js');
var Service = require('../../utils/service.js');
var app = getApp();
Page({
  data: {
    idnumber: '',
    t_unionid: '',
    t_openid: '',
    title: "录入信息",
    payModal: false, // 支付模态框
    measure_name: [],
    up_money: '',
    uo_price: [],
    // zhifu end
    measure_id: '',
    array: ['请选择', '小学', '初中', '高中（包括中专和普通高中）', '大学（包括高职、大专及本科）', '研究生及以上'],
    array1: ['请选择', '已婚', '未婚', '离异', '丧偶'],
    //职务
    array2: ['请选择', '义务兵', '下士', '中士', '上士', '四级军士长', '三级军士长', '二级军士长', '一级军士长'],
    //军兵种
    array3: ['请选择', '空军', '陆军', '海军', '火箭军', '战略支援部队', '武警', '其他'],
    date: '1980-01-01',
    jointime: '1980-01-01',
    time: '请选择时间',
    priceXin: '',
    items: [{
        name: '男',
        value: '男'
      },
      {
        name: '女',
        value: '女'
      },
    ],
    relationshipArr: [{
        name: '恩爱',
        value: '恩爱'
      },
      {
        name: '关系不和',
        value: '关系不和'
      },
      {
        name: '离异',
        value: '离异'
      },
      {
        name: '父亲或母亲离世',
        value: '父亲或母亲离世'
      }
    ],
    childstyleArr: [{
        name: '强制型',
        value: '强制型'
      },
      {
        name: '放任型',
        value: '放任型'
      },
      {
        name: '溺爱型',
        value: '溺爱型'
      },
      {
        name: '民主型',
        value: '民主型'
      },
    ],
    checkboxArr: [{
        name: 'A',
        value: 'A、压抑自己'
      },
      {
        name: 'B',
        value: 'B、找人倾诉,寻求帮助'
      },
      {
        name: 'C',
        value: 'C、否认并难以接受'
      },
      {
        name: 'D',
        value: 'D、饮酒,抽烟或依赖药物'
      },
      {
        name: 'E',
        value: 'E、发泄(毁物,虐待动物)'
      },
      {
        name: 'F',
        value: 'F、自我惩罚(自虐,自残等)'
      },
      {
        name: 'G',
        value: 'G、接受现实并总结经验'
      },
      {
        name: 'H',
        value: 'H、消遣娱乐(跑步,唱歌,爬山,打球)'
      },
      {
        name: 'I',
        value: 'I、相信可能会发生某种奇迹改变现状'
      },
    ],
    helpArr: [{
        name: '没有',
        value: '没有'
      },
      {
        name: '1~3人',
        value: '1~3人'
      },
      {
        name: '4~6人',
        value: '4~6人'
      },
      {
        name: '6~10人',
        value: '6~10人'
      },
      {
        name: '10人以上',
        value: '10人以上'
      },
    ],
    onlyArr: [{
        name: '是',
        value: '是'
      },
      {
        name: '否',
        value: '否'
      },
    ],
    marriageArr: [{
        name: '单身',
        value: '单身'
      },
      {
        name: '恋爱中',
        value: '恋爱中'
      },
      {
        name: '已婚',
        value: '已婚'
      },
    ],
    householdArr: [{
        name: '城市',
        value: '城市'
      },
      {
        name: '县城',
        value: '县城'
      },
      {
        name: '农村',
        value: '农村'
      },
    ],
    childhoodArr: [{
        name: '是',
        value: '是'
      },
      {
        name: '否',
        value: '否'
      },
    ],
    // fatherEduArr: ['请选择', '文盲', '小学', '中学', '大学', '研究生及以上'],
    // matherEduArr: ['请选择', '文盲', '小学', '中学', '大学', '研究生及以上'],
    matherEduArr: [{
        name: '文盲',
        value: '文盲'
      },
      {
        name: '小学',
        value: '小学'
      },
      {
        name: '中学',
        value: '中学'
      },
      {
        name: '大学',
        value: '大学'
      },
      {
        name: '研究生及以上',
        value: '研究生及以上'
      },
    ],
    childstudyArr: [{
        name: '隔代亲属',
        value: '隔代亲属'
      },
      {
        name: '旁系亲属',
        value: '旁系亲属'
      },
      {
        name: '无血缘关系的人',
        value: '无血缘关系的人'
      },
    ],
    difficultArr: [{
        name: '是',
        value: '是'
      },
      {
        name: '否',
        value: '否'
      },
      {
        name: '无血缘关系的人',
        value: '无血缘关系的人'
      },
    ],
    nationalArr: ["请选择", "汉族", "蒙古族", "回族", "藏族", "维吾尔族", "苗族", "彝族", "壮族", "布依族", "朝鲜族", "满族", "侗族", "瑶族", "白族", "土家族", "哈尼族", "哈萨克族", "傣族", "黎族", "傈僳族", "佤族", "畲族", "高山族", "拉祜族", "水族", "东乡族", "纳西族", "景颇族", "柯尔克孜族", "土族", "达斡尔族", "仫佬族", "羌族", "布朗族", "撒拉族", "毛南族", "仡佬族", "锡伯族", "阿昌族", "普米族", "塔吉克族", "怒族", "乌孜别克族", "俄罗斯族", "鄂温克族", "德昂族", "保安族", "裕固族", "京族", "塔塔尔族", "独龙族", "鄂伦春族", "赫哲族", "门巴族", "珞巴族", "基诺族"],
    sex: '',
    marr: '',
    username: '',
    username1: '',
    username2: '',
    index: 0,
    index2: 0,
    index3: 0,
    hun: 0,
    title1: "", // 答题
    content: '',
    otype: -2,
    lb_id: '',
    lb_tz: -1,
    tplb: -1,
    show: -1,
    showLoading: false,
    payFlag: false,
    btnFlag: true,
    payInfo: true,
    marketstatus: 0, //判断是否隐藏个人信息
    allData: '', //保存军人选择的信息
    select: 0,
    cehsi: 0,
    ageSol: "", //sol 年龄
    national: 0, // 民族
    unitName: "", // 单位名称
    only: '', // 独生子判断
    graduate: '', //是否最高学历毕业
    notgraduated: '', //未毕业原因
    marriage: '', // 婚姻状况
    household: '', //户籍所在地
    relation: '', // 父母关系
    fatherEdu: '', // 父亲文化程度
    matherEdu: '', // 母亲文化程度
    childhood: '', // 童年生活
    childstudy: '', // 童年学习
    childstyle: '', // 教养方式
    yingfuArr: [], // 应付方式
    difficult: '', //困难 
    help: '', // 帮助
    submitFlag: true, // 未支付开始按钮
    menudBtn: '',
    inquiry: '', //1二维码，2聊天页面心理体检
    inquiry_id: '', //心理体检量表ID
    viewrice: true, //判断是否显示量表价格
    dropDown: 8, //多少条显示展开折叠数
    animDropDown: {}, //动效
  },
  onLoad: function (options) {
    var that = this;
    /** otype=1 第一次未答完题进行第二题 || 从报告列表跳转 else 扫码过来 */
    that.data.otype = options.otype ? options.otype : -1;
    if (options.otype == 1) {
      wx.setStorageSync('qrcode_id', options.g_id ? options.g_id : 0);
    } else if (options.otype != 0) {
      var scene = decodeURIComponent(options.scene)
      wx.setStorageSync('qrcode_id', scene)
      that.data.scene = scene;
    }
    //如果inquiry存在则传不存在默认为1
    if (!Util.isEmpty(options.inquiry)) {
      that.data.inquiry = options.inquiry;
      that.data.inquiry_id = options.inquiry_id;
    } else {
      that.data.inquiry = 1;
    }
    wx.setNavigationBarTitle({
      title: that.data.title
    });
    wx.showLoading({
      title: '正在加载',
      mask:true
    });
  },
  onShow: function () {
    let that = this;
    that.setTime();
    that.login = that.selectComponent("#login");
    that.modal = that.selectComponent("#modal");
    that.answer = that.selectComponent("#answer");
    var otype = that.data.otype;
    otype = Number(otype);
    /** otype=1 第一次未答完题进行第二题 || 从报告列表跳转 else 扫码过来 */
    // if (Util.isEmpty(wx.getStorageSync('data').unionid)) {
    //   wx.login({
    //     success: function (msg) {
    //       Service.getOpenId(msg.code).then((res) => {
    //         wx.setStorageSync('user', res)
    //         return Service.getUserData(res.openid)
    //       }).then((res) => {
    //         if (Util.isEmpty(res.unionid)) {
    //           that.login.showLogin();
    //         } else {
    //           wx.setStorageSync('data', res)
    //           if (otype == 1) {
    //             var info = wx.getStorageSync('weiLb');
    //             that.loadItem(info);
    //           } else {
    //             var scene = decodeURIComponent(that.data.scene)
    //             wx.setStorageSync('qrcode_id', scene)
    //             that.loadScene(scene); // 加载二维码场景
    //           }
    //           that.loadData(); // 获取个人信息
    //           console.log('个人信息', that.data)
    //         }
    //       })
    //     }
    //   })
    // } 
    wx.login({
      success: function (msg) {
        Service.getOpenId(msg.code).then((res) => {
          if (Util.isEmpty(res.openid)) {
            wx.showModal({
              title: '提示',
              content: '当前网络不稳定，请重试',
              confirmText: '重试',
              showCancel: false,
              success(res) {
                if (res.confirm) {
                  that.onShow();
                }
              }
            })
            return;
          }
          wx.setStorageSync('user', res)
          if (otype == 1) {
            //不需要支付的量表
            let info = wx.getStorageSync('weiLb');
            that.loadItem(info);
          } else {
            //需要支付的量表 inquiry:2 im开具的量表 :1 二维码扫码
            let scene = that.data.inquiry == 2 ? decodeURIComponent(that.data.inquiry_id) : decodeURIComponent(that.data.scene);
            wx.setStorageSync('qrcode_id', scene)
            if (that.data.inquiry == 2)
              that.loadIMScene(scene); // 加载二维码场景
            else
              that.loadScene(scene); // 加载二维码场景          
          }
          that.loadData(); // 获取个人信息
          wx.setNavigationBarTitle({
            title: that.data.title
          });
        }).catch(function (imError) {
          wx.showModal({
            title: '提示',
            content: '当前网络不稳定，请重试',
            confirmText: '重试',
            showCancel: false,
            success(res) {
              if (res.confirm) {
                that.onShow();
              }
            }
          })
          console.log('"%cOpenId获取失败', "color:#ff0000", imError); // 登录失败
        });
      }
    })

  },
  //适配iphonex高度
  onReady: function () {
    // console.log('onready')
    let that = this;
    wx.getSystemInfo({
      success: (res) => {
        if (/^iPhone X.*/i.test(res.model)) {
          //是
          that.setData({
            menudBtn: 108
          })
        } else {
          //不是
          that.setData({
            menudBtn: 88
          })
        }
      }
    });
  },

  /**
   * 设置插件最大时间
   */
  setTime() {
    var that = this;
    var date = new Date();
    var year = date.getFullYear();
    var month = date.getMonth() + 1;
    var day = date.getDate();
    var str = year + "-" + month + "-" + day;
    var str1 = (year - 100) + "-" + month + "-" + day;
    that.setData({
      endTime: str, //最大时间
      retiretime: str,
      startTime: str1,
    })
  },

  /**
   * 加载二维码场景
   */
  loadScene(scene) {
    let that = this;
    wx.removeStorageSync('roomService');
    var user = wx.getStorageSync('user');
    var data = {
      z_openid: user.openid,
      g_id: scene
    };
    //加载二维码
    Service.loadScene(data).then((res) => {
      console.log("loadScene", res);
      var sumprice = 0;
      for (let i = 0; i < res.price.length; i++) {
        sumprice += parseInt(res.price[i]);
      }
      if (sumprice != res.money) {
        that.setData({
          viewrice: false,
        })
      }
      console.log("sumprice", sumprice);
      console.log("res.money", res.money)
      that.setData({
        t_openid: res.t_openid,
        t_unionid: res.t_unionid
      })
      // 返回 0  二维码已删
      if (Number(res) == 0) {
        wx.hideLoading()
        Util.alert('您扫的二维码已经失效，请联系咨询师。', function () {
          wx.switchTab({
            url: '/pages/index/index',
          })
        });
        return;
      } else if (res.marketstatus == 4) {
        wx.hideLoading()
        that.setData({
          show: 1,
          marketstatus: 4,
          showLoading: true,
          // zhifu 
          measure_name: res.measure_name,
          up_money: res.money,
          uo_price: res.price
        })
      } else if (res.unitid == '4725') {
        wx.hideLoading()
        that.setData({
          show: 2,
          marketstatus: 4,
          showLoading: true,
          // zhifu 
          measure_name: res.measure_name,
          up_money: res.money,
          uo_price: res.price
        })
      } else {
        wx.hideLoading()
        // 二维码未删除
        that.setData({
          show: 0,
          marketstatus: res.marketstatus,
          showLoading: true,
          // zhifu 
          measure_name: res.measure_name,
          up_money: res.money,
          uo_price: res.price
        })
      }
      wx.setStorageSync('weiLb', res)
      // 是否有未做完的题   res.characters_id 为null 时表示没有扫码后未做的量表;
      // res.record_id = res.characters_id ?res.characters_id:-1;
      if (res.characters_id) {
        res.record_id = res.characters_id
      } else {
        res.record_id = -1;
      }
      if (Number(res.type) == 3) {
        // 二维码已失效
        Util.alert('您扫的二维码已经失效!', function () {
          wx.switchTab({
            url: '/pages/index/index',
          })
        });
      } else if (Number(res.type) == 1) {
        // type 1 上次未做完  扫码继续做
        that.loadItem(res, scene);
      } else if (Number(res.type) == 2) {
        // 上次已做完，再次扫码需要支付 
        let json = {
          res: res,
          e: scene,
          otype: 0
        }
        // that.upPayBtn(json);
        that.setData({
          payModal: true
        })
        wx.setNavigationBarTitle({
          title: '支付检测费' //修改title
        })
        wx.setStorageSync('payInfo', json)
      } else {
        // status 0支付  1免费  2 体验金
        if (Number(res.status) == 0) {
          let json = {
            res: res,
            e: scene,
            otype: 0
          }
          // that.upPayBtn(json);
          that.setData({
            payModal: true
          })
          wx.setNavigationBarTitle({
            title: '支付检测费' //修改title
          })
          wx.setStorageSync('payInfo', json)
        } else { //   不需要免费、体验金
          var user = wx.getStorageSync('user');
          var data1 = {};
          data1.openid = user.openid;
          data1.gold = res.money;
          data1.unitid = res.unitid;
          data1.payargs = '';
          data1.type = res.status;
          data1.g_id = scene;
          var url = Api.HOST + 'wechatIteration.php?s=Home/paycs';
          Api.fetchPost(url, data1, (err, res1) => {
            if (Number(res1.ret) == 0) {
              let json = {
                res: res,
                e: scene,
                otype: 0
              }
              that.setData({
                payModal: true
              })
              wx.setNavigationBarTitle({
                title: '支付检测费' //修改title
              })
              // that.upPayBtn(json);
              wx.setStorageSync('payInfo', json)
            } else {
              that.loadItem(res, scene);
            }
          });
        }
      }
    })
  },
  /**加载IM量表场景 */
  loadIMScene(scene) {
    let that = this;
    var user = wx.getStorageSync('user');
    var data = {
      z_openid: user.openid,
      g_id: scene
    };
    //加载二维码
    Service.loadIMScene(data).then((res) => {
      let data = res.data;
      that.setData({
        t_openid: data.t_openid,
        t_unionid: data.t_unionid,
        viewrice: false, //不显示单个量表价格
      })
      /** 
       * 0 需要支付 
       * 1 已支付
       * -1 已做完
       */
      switch (res.code) {
        case 0:
          //0 需要支付 
          wx.hideLoading()
          that.setData({
            show: 0,
            marketstatus: data.marketstatus,
            showLoading: true,
            // zhifu 
            measure_name: data.measure_name,
            up_money: data.money,
            uo_price: data.price
          })
          wx.setStorageSync('weiLb', data)
          let json = {
            res: data,
            e: scene,
            otype: 0
          }
          // that.upPayBtn(json);
          that.setData({
            payModal: true
          })
          wx.setNavigationBarTitle({
            title: '支付检测费' //修改title
          })
          wx.setStorageSync('payInfo', json)
          break;
        case 1:
          // 1 已支付
          wx.hideLoading()
          that.setData({
            show: 0,
            marketstatus: data.marketstatus,
            showLoading: true,
            // zhifu 
            measure_name: data.measure_name,
            up_money: data.money,
            uo_price: data.price
          })
          wx.setStorageSync('weiLb', data)
          that.loadItem(data, scene);
          break;
        case -1:
          // -1 已做完
          wx.hideLoading()
          Util.alert(res.msg, function () {
            wx.switchTab({
              url: '/pages/index/index',
            })
          });
          return;
      }
    })
  },
  getUnitid: function (e) {
    let that = this
    var allData = wx.getStorageSync('data');
    var url = Api.HOST + 'wechatIteration.php?s=Money/is_unitid';
    var data = {
      openid: allData.openid
    }
    Api.fetchPost(url, data, (err, mres) => {
      let _json = {
        g_time: e.g_time,
        t_openid: mres.t_openid,
        unitid: mres.unitid
      }
      that.loadItem(_json);
    })
  },
  /**
   * 量表数量超过dropdown数量显示'展开'/'收起'
   * @param {*} e 
   */
  dropdown(e) {
    console.log(e.currentTarget.dataset.dropdown);
    let dropDown = e.currentTarget.dataset.dropdown;
    this.setData({
      dropDown: dropDown
    })
    //  //点击弹出
    //   if (dropDown==8) {
    //       //缩回动画
    //       this.popp();
    //   } else {
    //       //弹出动画
    //       this.takeback();
    //   }
  },
  positionNational: function (a, e) {
    var arr = a;
    for (var i = 0; i < arr.length; i++) {
      if (e == arr[i]) {
        return i
      }
      // console.log(i)
    }
  },
  /**
   * 自定义函数--支付功能
   * e---支付需要的参数
   * 
   * */
  upPayBtn: Util.debouce(function () {
    var payInfo = wx.getStorageSync('payInfo')
    wx.showLoading({
      mask:true
    })
    var that = this;
    if (that.data.btnFlag) {
      that.setData({
        btnFlag: false
      })
      var btntime = setTimeout(function () {
        that.setData({
          btnFlag: true
        })
      }, 1000)
      if (payInfo.otype == 0) {
        this.pay(payInfo.res, payInfo.e)
      } else if (payInfo.otype == 1) {
        this.payX(payInfo.price, payInfo.id, payInfo.time)
      }
    } else {
      clearTimeout(btntime);
      wx.showToast({
        title: '请勿重复点击',
        icon: 'none',
        duration: 1000
      })
    }

  }, 1000, true),
  /**
   * 心理健康早期筛查 支付
   * e == 支付钱数
   * arrId == 量表id
   * time === 加载题loadItem需要用到
   */
  payX: function (e, arrId, time) {
    console.log("payX");
    let that = this
    e = e
    var allData = wx.getStorageSync('data');
    var data = {};
    data.openid = allData.openid;
    data.gold = e;
    data.g_id = 0;
    // 添加参数
    var url = Api.HOST + 'wechatIteration.php?s=Home/payrecord';
    Api.fetchPost(url, data, (err, res) => {
      wx.hideLoading()
      if (res.ret == 1) {
        var payargs = res.info.parameter;
        var out_trade_no = res.info.dealarr.out_trade_no
        wx.requestPayment({
          timeStamp: payargs.timeStamp,
          nonceStr: payargs.nonceStr,
          package: payargs.package,
          signType: payargs.signType,
          paySign: payargs.paySign,
          success: function (res) {
            console.log('zhifu ', res)
            var url = Api.HOST + 'wechatIteration.php?s=Money/is_unitid';
            var data = {
              openid: allData.openid
            }
            Api.fetchPost(url, data, (err, mres) => {
              console.log('咨询师openid', mres.t_openid)
              that.setData({
                t_openid: mres.t_openid
              })
              var data1 = {};
              // 用户的openID 支付钱数  咨询师的unitID 微信的字符串认证
              data1.openid = allData.openid;
              data1.gold = e;
              data1.unitid = mres.unitid;
              data1.payargs = res.errMsg;
              data1.type = 0;
              data1.g_id = 0;
              var url = Api.HOST + 'wechatIteration.php?s=Home/paycs';
              Api.fetchPost(url, data1, (err, res) => {
                that.setData({
                  submitFlag: false, // 确定按钮状态
                  payModal: false, // 支付模态框消失
                })
                wx.setNavigationBarTitle({
                  title: '录入信息' //修改title
                })
                let _json = {
                  g_time: time,
                  t_openid: mres.t_openid,
                  unitid: mres.unitid,
                }
                that.loadItem(_json);
              });
            })
          },
          /**
           * 获取心理健康风险的unitID
           */
          fail: function (res) {},
          complete: function (res) {

            if (res.errMsg == "requestPayment:ok") {
              console.log('支付成功')
            } else {
              let msg = res.errMsg
              console.log('支付失败', res)
              var url = Api.HOST + 'wechatIteration.php?s=Money/is_unitid';
              var data = {
                openid: allData.openid
              }
              Api.fetchPost(url, data, (err, mres) => {
                let json = {
                  openid: allData.openid,
                  gold: e.money,
                  unitid: mres,
                  payargs: res.errMsg,
                  otype: 0,
                  g_id: 0,
                  t_openid: 1,
                  g_time: 0,
                  time: time,
                  out_trade_no: out_trade_no
                }
                that.payFiled(json)
              })
            }
          }
        })
      }
    })

  },
  // 心理健康早期筛查 支付失败
  payFiled: function (e) {
    var url = Api.HOST + 'wechatIteration.php?s=Home/payfailed';
    let that = this
    let data1 = {}
    data1.openid = e.openid;
    data1.gold = e.gold;
    data1.unitid = e.unitid;
    data1.payargs = e.msg;
    data1.type = e.otype;
    data1.g_id = e.g_id;
    data1.t_openid = e.t_openid;
    // data1.g_time = e.g_time;
    // data1.out_trade_no = e.out_trade_no
    // data1.nonceStr = e.nonceStr;
    // data1.paySign = e.paySign;
    console.log('data1', e, data1)
    Api.fetchPost(url, data1, (err, res) => {
      console.log('支付失败', res);
      that.setData({
        payModal: false, // 支付模态框消失
      })
      wx.setNavigationBarTitle({
        title: '录入信息' //修改title
      })
      if (res.trade_state_desc == '支付成功') {
        let _json = {
          openid: e.openid,
          money: e.gold,
          unitid: e.unitid,
          errMsg: res.errMsg,
          g_id: e.g_id,
          time: e.time,
        }
        that.payCsX(_json)
      } else {
        Util.alert('支付失败', function () {
          wx.reLaunch({
            url: '/pages/index/index',
            success: function () {

            }
          })
        })
      }

    })
  },
  /**
   * 扫码 支付
   * e == 支付参数
   * 
   * g_id === 扫码带的id
   */
  pay(e, g_id) {
    console.log("pay")
    console.log('e', e)
    let that = this;
    var user = wx.getStorageSync('user');
    var data = {};
    data.openid = user.openid;
    data.gold = e.money;
    // data.gold = 0.01;
    data.g_id = g_id;
    data.type = that.data.inquiry == 1 ? '1' : '4'; //量表1 服务2 药方3 im检测4
    // 添加参数
    var url = Api.HOST + 'wechatIteration.php?s=Home/payrecord';
    Api.fetchPost(url, data, (err, res) => {
      var prepay_id = res.info.parameter.package.substr(10, res.info.parameter.package.length)
      //  that.getTemplate(prepay_id, e);
      wx.hideLoading()
      if (res.ret == 1) {
        var out_trade_no = res.info.dealarr.out_trade_no;
        var nonceStr = res.info.parameter.nonceStr;
        var paySign = res.info.parameter.paySign
        var payargs = res.info.parameter;
        wx.requestPayment({
          timeStamp: payargs.timeStamp,
          nonceStr: payargs.nonceStr,
          package: payargs.package,
          signType: payargs.signType,
          paySign: payargs.paySign,
          success: function (res) {
            // that.payfailde(res, e, g_id, out_trade_no, nonceStr, paySign)
          },
          fail: function (res) {},
          complete: function (res) {
            console.log('complete', res)
            if (res.errMsg && res.errMsg == "requestPayment:ok") {
              console.log('支付成功')
              var data1 = {};
              // 用户的openID 支付钱数  咨询师的unitID 微信的字符串认证
              data1.openid = user.openid;
              data1.gold = e.money;
              data1.unitid = e.unitid;
              data1.payargs = res.errMsg;
              data1.type = 0;
              data1.g_id = g_id;
              // 咨询师的id
              var url = Api.HOST + 'wechatIteration.php?s=Home/paycs';
              Api.fetchPost(url, data1, (err, res) => {
                that.setData({
                  payModal: false, // 支付模态框消失
                })
                wx.setNavigationBarTitle({
                  title: '录入信息' //修改title
                })
                that.loadItem(e);
              });
            } else {
              that.payfailde(res, e, g_id, out_trade_no, nonceStr, paySign)
            }

          }
        })
      } else {
        Util.alert(res.msg);
      }
    });
  },
  /**
   * 扫码支付失败
   * 失败时需检测商户平台是否支付成功
   */
  payfailde(res, e, g_id, f_id, nonceStr, paySign) {
    let that = this
    let msg = res.errMsg
    console.log('支付失败', msg, res)
    var url = Api.HOST + 'wechatIteration.php?s=Home/payfailed';
    let data1 = {}
    let user = wx.getStorageSync('user')
    data1.openid = user.openid;
    data1.gold = e.money;
    data1.unitid = e.unitid;
    data1.payargs = msg;
    data1.type = 0;
    data1.g_id = g_id;
    data1.t_openid = e.t_openid;
    data1.g_time = e.g_time || e.time;
    data1.out_trade_no = f_id;
    // data1.out_trade_no = '2018080875290'
    // data1.nonceStr = nonceStr;
    // data1.paySign = paySign;
    console.log('data1', e, data1)
    Api.fetchPost(url, data1, (err, res) => {
      console.log('支付失败', res)
      // that.setData({
      //   payModal: false, // 支付模态框消失
      // })
      if (res.trade_state_desc == '支付成功') {
        let _json = {
          openid: user.openid,
          money: e.money,
          unitid: e.unitid,
          errMsg: res.errMsg,
          g_id: e.g_id,
          g_time: e.g_time || e.time,
          t_openid: e.t_openid
        }
        console.log('dingdan')
        that.payCs(_json)
      } else {
        Util.alert('支付失败', function () {
          // wx.reLaunch({
          //   url: '/pages/index/index',
          //   success: function() {}
          // })
        })
      }
    })
  },
  // 扫码支付失败---> 检测商户平台支付成功-->调用paycs接口进行加载
  //  e  参数
  payCs(e) {
    let that = this
    var data1 = {};
    // 用户的openID 支付钱数  咨询师的unitID 微信的字符串认证
    data1.openid = e.openid;
    data1.gold = e.money;
    data1.unitid = e.unitid;
    data1.payargs = e.errMsg;
    data1.type = 0;
    data1.g_id = e.g_id;
    // 咨询师的id
    var url = Api.HOST + 'wechatIteration.php?s=Home/paycs';
    Api.fetchPost(url, data1, (err, res) => {
      that.setData({
        payModal: false, // 支付模态框消失
      })
      wx.setNavigationBarTitle({
        title: '录入信息' //修改title
      })
      that.loadItem(e);
    });
  },
  // 心理健康风险支付失败---> 检测商户平台支付成功-->调用paycs接口进行加载
  //  e  参数
  payCsX(e) {
    let that = this
    var data1 = {};
    // 用户的openID 支付钱数  咨询师的unitID 微信的字符串认证
    data1.openid = e.openid;
    data1.gold = e.money;
    data1.unitid = e.unitid;
    data1.payargs = e.errMsg;
    data1.type = 0;
    data1.g_id = 0;
    var url = Api.HOST + 'wechatIteration.php?s=Home/paycs';
    Api.fetchPost(url, data1, (err, res) => {
      that.setData({
        submitFlag: false, // 确定按钮状态
        payModal: false, // 支付模态框消失
      })
      wx.setNavigationBarTitle({
        title: '录入信息' //修改title
      })
      let _json = {
        g_time: e.time,
        t_openid: e.t_openid,
        unitid: e.unitid,
      }
      that.loadItem(_json);
    });
  },
  // 关闭支付按钮
  closePay() {
    wx.switchTab({
      url: '/pages/index/index',
    })
  },
  /**
   * 自定义函数---加载量表数据
   * 参数e--- measure_id---量表id
   * money--量表支付的钱
   * status---是否允许查看报告
   * is_type---是否免费检测
   * 
   * */
  loadItem(e) {
    let that = this;
    var weiLb = wx.getStorageSync("weiLb");
    //扫码== 判断状态是marketstatus == 4 || 从报告也进入判断状态是  weiLb.m== 4
    if (weiLb.marketstatus) { // 只添加扫码时的状态
      if (weiLb.marketstatus == 4) { //  军队
        this.setData({
          show: 1,
          marketstatus: 4,
          showLoading: true
        })
      } else if (weiLb.unitid == '4725') {
        this.setData({
          show: 2,
          marketstatus: 4,
          showLoading: true
        })
      } else {
        this.setData({
          show: 0,
          showLoading: true
        })
      }
    }
    var user = wx.getStorageSync('user');
    var data = {};
    var urlt = Api.HOST + 'wechatIteration.php?s=Measure/up_price';
    data.z_openid = user.openid;
    data.t_openid = e.t_openid;
    data.g_time = e.g_time || e.time;
    data.inquiry = that.data.inquiry;
    data.inquiry_id = that.data.inquiry_id;
    Api.fetchPost(urlt, data, (err, res) => {
      // that.setData({ show: true }).
      // 判断量表是不是他评量表  由谁测试
      if (res[0]) {
        that.setData({
          lb_id: res[0]
        })
        // 保存 信息  用于判断是不是同一个量表   
        var lb_descript = {
          id: res,
          desc: e
        }
        wx.setStorageSync("lb_descript", lb_descript);
        // 加载量表 包括题答案
        if (Number(res[0]) != 616) {
          var url = Api.HOST_xinli_lb + 'measure/' + res[0] + '.json';
          var data = {};
          data.measure_id = res[0];
          wx.request({
            method: 'POST',
            url: url,
            // data: data,
            header: {
              'content-type': 'application/x-www-form-urlencoded'
            },
            success(re) {
              let res = re.data;
              wx.hideLoading()
              // 设置当前页量表信息的显示
              that.setData({
                content: res[0].measure_desc,
                title1: res[0].measure_name,
                measure_id: data.measure_id,
                payFlag: true
              })
              // 存储量表信息
              res[0].measure_id = data.measure_id;
              wx.setStorageSync('lb_swiper_con', res)
              // 判断他评量表
              if (res[0].type == 1) {} else if (Number(res[0].type) == 3) {
                //  瑞文
                that.setData({
                  lb_tz: 3
                })
                var obj = {
                  res: res,
                  talp: 1
                }
                wx.setStorageSync('liangbiaoCon', obj)
              } else {
                that.setData({
                  lb_tz: 0
                })
                var obj = {
                  res: res,
                  talp: 1
                }
                wx.setStorageSync('liangbiaoCon', obj)
              }
              wx.setStorageSync('lb_tz', -1)
            },
            fail(e) {
              console.error(e)
            }
          })
        }
      } else {
        wx.showModal({
          title: '提示',
          cancelText: '取消',
          confirmText: '确定',
          content: "支付成功，这是他评量表，由咨询师负责评估，请联系您的咨询师开始测试。",
          success: function (res) {
            if (res.confirm) {
              wx.switchTab({
                url: '/pages/index/index',
              })
            } else if (res.cancel) {
              wx.switchTab({
                url: '/pages/index/index',
              })
            }
          }
        })
      }
    })
  },
  cmi: function () {
    console.log(0)
    var lb_swiper_con = wx.getStorageSync('lb_swiper_con');
    var liangbiaoCon = wx.getStorageSync('liangbiaoCon');
    var _len = Object.getOwnPropertyNames(liangbiaoCon.res[1])
    // console.log(_len.length != 2, _len.length,'/////////////')
    if (_len.length != 2) return;
    if (this.data.sex == '女') { //  女 == 1 男 === 2
      liangbiaoCon.res[1] = liangbiaoCon.res[1][1];
      lb_swiper_con[1] = lb_swiper_con[1][1];
    } else {
      liangbiaoCon.res[1] = liangbiaoCon.res[1][2];
      lb_swiper_con[1] = lb_swiper_con[1][2];
    }
    wx.setStorageSync('liangbiaoCon', liangbiaoCon);
    wx.setStorageSync('lb_swiper_con', lb_swiper_con);
  },
  submit: function () {
    var that = this;
    if (this.data.measure_id == 86) {
      this.cmi();
    }
    if (this.data.marketstatus != 4) {
      if (this.data.payFlag) {
        var user = wx.getStorageSync('user');
        var unitid = (user.unitid || user.unitid != 0) ? user.unitid : "";
        // let data1 = { user_number: user.openid };
        var urlt = Api.HOST + 'appIteration.php?s=Home/stinfo';
        var data = {};
        data.name = this.data.username;
        // data.hunfou = this.data.array1[this.data.select];  // 婚姻状况
        data.profession = this.data.username2 || ''; // 职业
        data.birthday = this.data.date;
        data.sex = this.data.sex;
        data.unitid = unitid ? unitid : '';
        data.formId = '';
        data.openid = user.openid;
        // 新添加学历功能
        data.edu = this.data.index;
        if (data.name == '' || data.name == 'null' || data.sex == "null" || data.sex == "" || data.birthday == '' || data.birthday == 'null' || data.edu == 0) {
          // wx.hideLoading()
          clearTimeout(timer1)
          that.setData({
            payInfo: true
          })
          Util.alert('请完善信息');
          return;
        }
        var timer1 = setTimeout(function () {
          // Util.alert("加载失败，请重试")
          wx.hideLoading();
          that.setData({
            payInfo: true
          })
        }, 5000)
        wx.showLoading({
          title: '请稍后',
          mask:true
        })
        //  改变按钮状态
        this.setData({
          payInfo: false
        })
        // 为了设置做某个量表需要用到性别信息 量表id == 2 || id== 3
        var judgeSex = 0;
        if (data.sex == '男') {
          judgeSex = 1;
        }
        wx.setStorageSync("judgeSex", judgeSex);
        Api.fetchPost(urlt, data, (err, res) => {
          wx.hideLoading()
          clearTimeout(timer1)
          // 个人信息提交成功  返回ret== 1
          if (res.code == 1) {
            console.log("that.data.lb_id",that.data.lb_id)
            // otype = 0  从首页进入需要支付  现在已移除
            // otype = 1  从报告页面进入  不需要支付
            // otype 不存在 = -1  扫码进入
            // lb_tz 判断进入那个答题页面  3 -> 瑞文  0 -> 普通
            if (that.data.otype == 0 && that.data.lb_tz == '-1') {

            } else if (Number(that.data.lb_id) == 10) {
              // 防御方式
              wx.navigateTo({
                url: '/pages/dati/dati',
                success: function () {
                  wx.hideLoading()
                  setTimeout(function () {
                    that.setData({
                      payInfo: true
                    })
                  }, 500)
                }
              })
            } else if (that.data.lb_tz == '3') {
              // 瑞文高级和瑞文推理
              wx.navigateTo({
                url: '/pages/dati03/dati03',
                success: function () {
                  wx.hideLoading()
                  setTimeout(function () {
                    that.setData({
                      payInfo: true
                    })
                  }, 500)
                }
              })
            } else if (Number(that.data.lb_id) == 145) {
              // 生活事件量表
              wx.navigateTo({
                url: '/pages/dati05/dati05',
                success: function () {
                  wx.hideLoading()
                  setTimeout(function () {
                    that.setData({
                      payInfo: true
                    })
                  }, 500)
                }
              })
            } else {
              // 进入普通的答题页面
              if (that.data.monitor == 1) {
                console.log(that.data.lb_id, 'asdasdasdaas')
                var url = '/pages/dati04/dati04?monitor=1&g_id=' + that.data.monitor_id;

              } else if (that.data.inquiry == 2) { //聊天页面心理体检
                var url = '/pages/dati04/dati04?inquiry=2&inquiry_id=' + that.data.inquiry_id;
              } else {
                var url = '/pages/dati04/dati04';
              }
              wx.navigateTo({
                url: url,
                success: function () {
                  wx.hideLoading()
                  setTimeout(function () {
                    that.setData({
                      payInfo: true
                    })
                  }, 500)
                }
              })
            }

          } else {
            Util.alert(res.msg);
          }
        });
      }
    } else {
      var allScore = wx.getStorageSync("testData");
      var jifen = wx.getStorageSync("scoreData");
      var time01 = wx.getStorageSync("time01");
      var itemData = wx.getStorageSync("itemData");
      if (that.data.otype == 0 && that.data.lb_tz == '-1') {

      } else if (Number(that.data.lb_id) == 10) {
        // 防御方式
        wx.navigateTo({
          url: '/pages/dati/dati',
          success: function () {
            wx.hideLoading()
            setTimeout(function () {
              that.setData({
                payInfo: true
              })
            }, 500)
          }
        })
      } else if (that.data.lb_tz == '3') {
        // 瑞文
        wx.navigateTo({
          url: '/pages/dati03/dati03',
          success: function () {
            wx.hideLoading()
            setTimeout(function () {
              this.setData({
                payInfo: true
              })
            }, 500)
          }
        })
      } else {
        // 进入普通的答题页面
        wx.navigateTo({
          url: '/pages/dati04/dati04',
          success: function () {
            wx.hideLoading()
            setTimeout(function () {
              that.setData({
                payInfo: true
              })
            }, 500)
          }
        })
      }
    }
  },
  selectCheckBox: function (e) {
    // console.log(e)
    var len = e.split(",");
    // console.log(len)
    var arr = this.data.checkboxArr;
    for (let i = 0; i < arr.length; i++) {
      for (let j = 0; j < len.length; j++) {
        if (arr[i].name == len[j]) {
          arr[i].checked = 'true';
        }
      }
    }
    this.setData({
      checkboxArr: arr
    })
  },
  /**
   * 自定义函数---加载数据
   * */
  loadData() {
    var that = this;
    // 获取授权  上传头像昵称  得到这个用户的信息
    var url = Api.HOST + 'wechatIteration.php?s=Home/getinfo';
    var data = {};
    var user = wx.getStorageSync('user');
    if (this.data.tplb != '1') {
      data.openid = user.openid;
    } else {
      var info = wx.getStorageSync('tplbDetail');
      data.openid = info.z_openid;
    }
    Api.fetchPost(url, data, (err, res) => {
      if (res.info) {
        if (res.info.graduate) {
          that.setData({
            username: res.info.name,
            sex: res.info.sex,
            date: res.info.birthday,
            idnumber: res.info.idnumber ? res.info.idnumber : '',
            jointime: res.info.jointime ? res.info.jointime : that.data.jointime,
            retiretime: res.info.retiretime ? res.info.retiretime : that.data.retiretime,
            graduate: res.info.graduate,
            index: res.info.edu,
            select: res.info.select,
            index2: res.info.index2,
            index3: res.info.index3,
            household: res.info.Location,
            notgraduated: res.info.notgraduated ? res.info.notgraduated : '',
          })
        } else if (res.info.Location) {
          var con = res.info;
          var nationalArr = that.data.nationalArr;
          // console.log(res.info, '56565')
          var ind = that.positionNational(nationalArr, con.native_place); //民族
          that.selectCheckBox(con.coping_style_one);
          // var indP = that.positionNational(nationalArr, con.native_place);// 父亲文化程度
          // var indF = that.positionNational(nationalArr, con.native_place);// 母亲文化程度
          if (con.childhood_one == '是') {
            con.childhood_two = '';
          } else {
            con.childhood_two = con.childhood_two
          }
          that.setData({
            username2: res.info.profession ? res.info.profession : ' ',
            username: con.name,
            sex: con.sex,
            date: con.birthday,
            national: ind,
            unitName: con.ask_department,
            only: con.Only_child,
            marriage: con.hunfou,
            index: con.edu,
            household: con.Location,
            relation: con.Family_situation,
            fatherEdu: con.cultural_father,
            matherEdu: con.cultural_mother,
            childhood: con.childhood_one,
            childstudy: con.childhood_two,
            childstyle: con.childhood_three,
            yingfuArr: con.coping_style_one,
            difficult: con.coping_style_two,
            help: con.coping_style_three,
          })
        } else {
          // console.log('55555555555555555555555555555',res.info)
          if (res.info.cultural == '') {
            res.info.cultural = 0;
          } else {
            res.info.cultural = res.info.cultural;
          }
          if (res.info.birthday == null) {
            res.info.birthday = "请选择";
          } else {
            res.info.birthday = res.info.birthday;
          }
          that.setData({
            username: res.info.name,
            index: res.info.cultural,
            date: res.info.birthday,
            sex: res.info.xingbie,
            select: res.info.hunfou,
            username1: res.info.ask_department,
            username2: res.info.profession ? res.info.profession : ' ',
          });
        }

      }
    });
  },

  // 时间转换
  resTime: function (str) {
    var hour = str.split(":")[0];
    var minute = str.split(":")[1];
    var sec = str.split(":")[2];
    return (hour * 3600 + minute * 60 + sec);
  },
  fengei: function (str) {
    return str.split(',');
  },
  // 数组求和
  add: function (arr) {
    var num = 0;
    for (let i = 0; i < arr.length; i++) {
      num += Number(arr[i]);
    }
    return num;
  },
  // 姓名
  inputChange: function (e) {
    this.setData({
      username: e.detail.value,
    })
  },
  // 单位名称
  inputChange1: function (e) {
    this.setData({
      username1: e.detail.value,
    })
  },
  // 职业
  inputChange2: function (e) {
    this.setData({
      username2: e.detail.value,
    })
  },
  // 身份证号
  inputChange3: function (e) {
    this.setData({
      idnumber: e.detail.value,
    })
  },
  //未毕业原因
  inputnotGraduated: function (e) {
    this.setData({
      notgraduated: e.detail.value,
    })
  },
  people: function (e) {
    this.setData({
      multiIndex: e.detail.value
    })
  },

  //性别
  radioChange: function (e) {
    this.setData({
      sex: e.detail.value,
    })
  },

  radioChange1: function (e) {
    this.setData({
      marr: e.detail.value,
    })
  },
  //日期
  bindDateChange: function (e) {
    this.setData({
      date: e.detail.value
    })
  },
  //入伍日期
  bindDateChange1: function (e) {
    this.setData({
      jointime: e.detail.value
    })
  },
  //退伍日期
  bindDateChange2: function (e) {
    this.setData({
      retiretime: e.detail.value
    })
  },
  // 学历
  bindPickerChange: function (e) {
    var num = e.detail.value;
    this.setData({
      index: num
    })
  },
  // 婚姻状况
  bindPickerChange1: function (e) {
    var num = e.detail.value;
    this.setData({
      select: num
    })
  },
  // 职务
  bindPickerChange2: function (e) {
    var num = e.detail.value;
    this.setData({
      index2: num
    })
  },
  // 军兵种
  bindPickerChange3: function (e) {
    var num = e.detail.value;
    this.setData({
      index3: num
    })
  },
  // 下拉刷新
  onPullDownRefresh: function () {
    wx.stopPullDownRefresh()
  },
  // 军人年龄 
  inputChangeAge: function (e) {
    var num = e.detail.value;
    num = num.replace(/^[0]+/, "");
    console.log(num)
    this.setData({
      ageSol: num
    })
  },
  // 验证年龄
  solAge: function (e) {
    var num = e.detail.value;
    console.log(0 <= Number(num) && Number(num) <= 150)
    var age;
    if (0 <= Number(num) && Number(num) <= 150) {
      age = num
    } else {
      age = ""
    }
    this.setData({
      ageSol: age
    })
  },
  // 民族
  bindPickerChangeNational: function (e) {
    var num = e.detail.value;
    this.setData({
      national: num
    })
  },
  // 单位名称 -- sol
  inputChangeUnit: function (e) {
    var num = e.detail.value;
    this.setData({
      unitName: num
    })
  },

  // 选择是否独生子
  radioChangeOnly: function (e) {
    // console.log(e)
    this.setData({
      only: e.detail.value
    })
  },
  //最高学历是否毕业
  radioChangeGraduate: function (e) {
    console.log("graduate", e.detail.value)
    this.setData({
      graduate: e.detail.value
    })
  },
  // 婚姻状况
  radioChangeMarriage: function (e) {
    this.setData({
      marriage: e.detail.value
    })
  },
  // 户籍所在地
  radioChangeHousehold: function (e) {
    this.setData({
      household: e.detail.value
    })
  },
  // 父母关系
  radioChangeRela: function (e) {
    this.setData({
      relation: e.detail.value
    })
  },
  //  父文化程度radioChangeRela
  radioChangeFatherEdu: function (e) {
    // console.log(e)
    this.setData({
      fatherEdu: e.detail.value
    })
  },
  //  母文化程度
  radioChangeMatherEdu: function (e) {
    // console.log(e)
    var num = e.detail.value;
    this.setData({
      matherEdu: num
    })
  },
  // 童年生活
  radioChangeChild: function (e) {
    if (e.detail.value == '是') {
      this.setData({
        childstudy: '',
      })
    }
    this.setData({
      childhood: e.detail.value
    })
  },
  // 童年学习
  radioChangeChildStu: function (e) {
    var childhood = this.data.childhood;
    console.log(childhood, 'childhood')
    if (childhood == '是') {
      this.setData({
        childstudy: ''
      })
    } else {
      console.log(1)
      this.setData({
        childstudy: e.detail.value
      })
    }

  },
  // 教养方式
  radioChangeChildSty: function (e) {
    this.setData({
      childstyle: e.detail.value
    })
  },
  /*
  // 精神状况
  radioChangeMenH: function (e) {
    this.setData({
      mentalheal: e.detail.value
    })
  },
  // 精神状况
  radioChangeMenL: function (e) {
    this.setData({
      mentalheal_1: e.detail.value
    })
  },
  // 精神状况
  radioChangeMenP: function (e) {
    this.setData({
      mentalheal_2: e.detail.value
    })
  },
  */
  // 应付方式复选框
  checkboxChange: function (e) {
    console.log('checkbox发生change事件，携带value值为：', e.detail.value)
    this.setData({
      yingfuArr: e.detail.value
    })
  },
  // 困难
  radioChangeDif: function (e) {
    this.setData({
      difficult: e.detail.value
    })
  },
  // 困难
  radioChangeHelp: function (e) {
    this.setData({
      help: e.detail.value
    })
  },
  // 下一步
  next: function () {
    let that = this;
    var name = this.data.username; // 姓名
    var sex = this.data.sex; // 性别
    var age = this.data.date; // 年龄
    var national = this.data.nationalArr[this.data.national] // 民族
    var unit = this.data.unitName; // 单位名称
    var only = this.data.only; // 独生子女
    var marriage = this.data.marriage; // 婚姻状况
    var edu = this.data.index; // 教育程度
    var household = this.data.household; // 户籍所在地
    var relation = this.data.relation; // 父母关系
    // 父母文化程度
    var fatherEdu = this.data.fatherEdu;
    var matherEdu = this.data.matherEdu;
    var childhood = this.data.childhood; // 童年生活
    // console.log(childhood, 'childhood')
    if (childhood == '是') {
      var childstudy = '';
    } else {
      var childstudy = this.data.childstudy; // 生活学习
    }
    var childstyle = this.data.childstyle; // 方式
    // var mentalheal = this.data.mentalheal; // 精神打击
    // var mentalheal_1 = this.data.mentalheal_1; // 精神病患者
    // var mentalheal_2 = this.data.mentalheal_2; // 自杀者
    var yingfuArr = this.data.yingfuArr; // 应付方式
    var difficult = this.data.difficult; // 遇到困难
    var help = this.data.help;
    // console.log(data,'data')
    if (name == '') {
      Util.alert('请输入姓名');
      return;
    }
    if (sex == '') {
      Util.alert('请选择性别');
      return;
    }
    if (age == '') {
      Util.alert('请输入年龄');
      return;
    }
    if (national == '请选择') {
      Util.alert('请选择民族');
      return;
    }
    if (unit == '') {
      Util.alert('请输入单位名称');
      return;
    }
    if (only == '') {
      Util.alert('是否是独生子女');
      return;
    }
    if (marriage == '') {
      Util.alert('请完善婚姻状况');
      return;
    }
    if (edu == 0) {
      Util.alert('请选择学历');
      return;
    }
    if (household == '') {
      Util.alert('请选择家庭所在地');
      return;
    }
    if (household == '') {
      Util.alert('请选择家庭所在地');
      return;
    }
    if (relation == '' || fatherEdu == '' || matherEdu == '') {
      Util.alert('请完善家庭关系栏目');
      return;
    }
    if (childhood == '是') {
      if (childhood == '' || childstyle == '') {
        Util.alert('请完善童年生活栏目');
        return;
      }
    } else {
      if (childhood == '' || childstudy == '' || childstyle == '') {
        Util.alert('请完善童年生活栏目');
        return;
      }
    }

    if (yingfuArr.length == 0 || difficult == '' || help == '') {
      Util.alert('请完善应对方式栏目');
      return;
    }
    var user = wx.getStorageSync("user");
    var data = {
      name: name,
      sex: sex,
      birthday: age,
      native_place: national,
      ask_department: unit,
      Only_child: only,
      hunfou: marriage,
      edu: edu,
      Location: household,
      Family_situation: relation,
      cultural_father: fatherEdu,
      cultural_mother: matherEdu,
      childhood_one: childhood,
      childhood_two: childstudy,
      childhood_three: childstyle,
      // mentalheal: mentalheal,
      // mentalheal_1: mentalheal_1,
      // mentalheal_2: mentalheal_2,
      coping_style_one: yingfuArr,
      coping_style_two: difficult,
      coping_style_three: help,
      openid: user.openid
    }
    var judgeSex = 0;
    if (data.sex == '男') {
      judgeSex = 1;
    }
    wx.setStorageSync("judgeSex", judgeSex);
    console.log(data, 'data')
    var urlt = Api.HOST + 'appIteration.php?s=Home/stinfo';
    wx.showLoading({
      title: '正在上传',
      mask:true
    })
    var uploadData = setTimeout(function () {
      wx.hideLoading()
      wx.showToast({
        icon: 'none',
        title: '您当前的网络不稳定，请检查网络重新提交。',
        duration: 2000
      })
    }, 5000)
    Api.fetchPost(urlt, data, (err, res) => {
      wx.hideLoading();
      clearTimeout(uploadData)
      console.log(res, 'res')
      if (res.code == 1) {
        that.setData({
          show: 0,
        })
      } else if (res.code == 0) {
        Util.alert(res.msg);
      }
    })
  },
  // 下一步 王好博
  next1: function () {
    let that = this;
    var name = this.data.username; // 姓名
    var idnumber = this.data.idnumber; // 身份证号
    var sex = this.data.sex; // 性别
    var age = this.data.date; // 年龄
    var jointime = this.data.jointime // 入伍时间
    var retiretime = this.data.retiretime; // 退伍时间
    var index2 = this.data.index2; // 职务
    var index3 = this.data.index3; // 军兵种
    var graduate = this.data.graduate; // 最高学历  
    var notgraduated
    if (graduate == '否') {
      notgraduated = this.data.notgraduated;
    } else {
      notgraduated = '';
    } // 原因
    var select = this.data.select; // 婚姻状况
    var edu = this.data.index; // 教育程度
    var household = this.data.household; // 户籍所在地
    if (name == '') {
      Util.alert('请输入姓名');
      return;
    }
    if (idnumber == '' || idnumber.length != 18) {
      Util.alert('请输入正确的身份证号');
      return;
    }
    if (sex == '') {
      Util.alert('请选择性别');
      return;
    }
    if (age == '') {
      Util.alert('请输入年龄');
      return;
    }
    if (jointime == '') {
      Util.alert('请输入入伍时间');
      return;
    }
    if (retiretime == '') {
      Util.alert('请输入退伍时间');
      return;
    }
    if (index2 == 0) {
      Util.alert('请选择职务');
      return;
    }
    if (index3 == 0) {
      Util.alert('请选择军兵种');
      return;
    }
    if (select == 0) {
      Util.alert('请选择婚恋状况');
      return;
    }
    if (edu == 0) {
      Util.alert('请选择学历');
      return;
    }
    if (graduate == '') {
      Util.alert('是否是最高学历毕业');
      return;
    }
    if (graduate == '否' && notgraduated == '') {
      Util.alert('请完善未最高学历毕业的原因');
      return;
    }
    if (household == '') {
      Util.alert('请选择家庭所在地');
      return;
    }
    var user = wx.getStorageSync("user");
    var data = {
      name: name,
      sex: sex,
      birthday: age,
      idnumber: idnumber,
      jointime: jointime,
      retiretime: retiretime,
      index2: index2,
      index3: index3,
      select: select,
      edu: edu,
      Location: household,
      graduate: graduate,
      notgraduated: notgraduated,
      openid: user.openid
    }
    var judgeSex = 0;
    if (data.sex == '男') {
      judgeSex = 1;
    }
    wx.setStorageSync("judgeSex", judgeSex);
    console.log(data, 'data')
    var urlt = Api.HOST + 'appIteration.php?s=Home/stinfo';
    wx.showLoading({
      title: '正在上传',
      mask:true
    })
    var uploadData = setTimeout(function () {
      wx.hideLoading()
      wx.showToast({
        icon: 'none',
        title: '您当前的网络不稳定，请检查网络重新提交。',
        duration: 2000
      })
    }, 5000)
    Api.fetchPost(urlt, data, (err, res) => {
      wx.hideLoading();
      clearTimeout(uploadData)
      console.log(res, 'res')
      if (res.code == 1) {
        that.setData({
          show: 0,
        })
      } else if (res.code == 0) {
        Util.alert(res.msg);
      }
    })
  },
  // //弹出动画
  // popp: function () {
  //     //plus顺时针旋转
  //     var animationInput = wx.createAnimation({
  //         duration: 500,
  //         timingFunction: 'linear'
  //     })
  //     animationInput.height(0).step();
  //     this.setData({
  //       animDropDown: animationInput.export(),
  //     })
  // },
  // //收回动画
  // takeback: function () {
  //     //plus逆时针旋转
  //     var animationInput = wx.createAnimation({
  //         duration: 500,
  //         timingFunction: 'linear'
  //     })
  //     animationInput.height(0).step();
  //     this.setData({
  //         animDropDown: animationInput.export(),
  //     })
  // },

  //登陆后组件回调方法刷新当前页面
  _refreshEvent() {
    console.log("刷新");
    this.onShow();
  },
})