const City = require('../../utils/city.js');
const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');
Page({
  data: {
    provinceTab: 0, //省级idx
    selectidx: 0,
    selectidx2: 0,
    cityTab: 0, //市级idx
    switchIdx: 0, //top筛选
    cityArray: City.cityArray,
    issue: City.issue,
    issueTab: 0,
    issueIndex: 0, //常见问题选择下标
    cesel: 17,
    userInfo: {},
    zxjh: [],
    noRecord: {
      winH: null,
    },
    filtrateSelect: false,
    index: 0,
    moneyidx: 0, //价格区间下标
    titleArray: [{
        name: '主任医师',
        key: '4'
      },
      {
        name: '副主任医师',
        key: '3'
      },
      {
        name: '主治医师',
        key: '2'
      },
      {
        name: '住院医师',
        key: '1'
      },
      {
        name: '国家心理治疗师',
        key: '5'
      },
      {
        name: '国家二级心理咨询师',
        key: '6'
      },
      {
        name: '国家三级心理咨询师',
        key: '7'
      }
    ],
    titleidx: 0, //医生职称下标
    moneyArray: [{
        name: '1-50',
        key: '1-50'
      },
      {
        name: '50-100',
        key: '50-100'
      },
      {
        name: '100-200',
        key: '100-200'
      },
      {
        name: '200以上',
        key: '200'
      }
    ],
    currentTab: 0,
    navScrollLeft: 0,
    citySelect: false,
    page: 0,
    doctorList: [],
    inputSelect: '',
    is_search: 0,
    moneySearch: '筛选',
    issueSearch: '常见问题', //常见问题文字
    scrollFlag: '',
    scrollFlag1: true,
    success: false,
    selectIssue: false, //常见问题加粗
    selectSearch: false, //筛选加粗,
    door: '',
    lcxl: '',
    shxl: '',
    title: '',
    counsel: '',
    price: '',
    province: '',
    city: '',
    searchName: '',
    goodat: '',
    counsel1: '',
    price1: '',
    title1: '',
    showview: false,
  },
  onLoad: function (options) {
    var that = this;
    that.setData({
      inputShowed: Number(options.inputShowed)
    })
    if (options.door) {
      console.log('door', options.door)
      switch (Number(options.door)) {
        case 1:
          that.setData({
            issueTab: 5
          })
          break;
        case 2:
          that.setData({
            issueTab: 1
          })
          break;
        case 3:
          that.setData({
            issueTab: 0
          })
          break;
        case 4:
          that.setData({
            issueTab: 2
          })
          break;
        case 5:
          that.setData({
            issueTab: 3
          })
          break;
        case 6:
          that.setData({
            issueTab: 4
          })
          break;
      }
      console.log('issueTab', that.data.issueTab)
    }
    /**获取系统信息 */
    wx.getSystemInfo({
      success: function (res) {
        that.setData({
          ["noRecord.winH"]: res.windowHeight
        });
      }
    });
    if (options.door) {
      that.setData({
        door: options.door
      })
    } else if (options.lcxl) {
      that.setData({
        lcxl: options.lcxl
      })
    } else if (options.shxl) {
      that.setData({
        shxl: options.shxl
      })
    }
		that.search('0')
  },
  // onShow() {   
  //    this.search('0')
  //   },
  //搜素确认
  search (page) {
    let that = this
    that.setData({
      showview: false
    })
    let data = {}
    data.page = page //	页数
    data.door = that.data.door; //门诊参数
    data.lcxl = that.data.lcxl; //临床心理
    data.shxl = that.data.shxl; //社会心理	
    data.title = that.data.title; //职称
    data.counsel = that.data.counsel; //	服务类型
    data.price = that.data.price; //价格区间
		if (that.data.province == '' || that.data.province == '热门城市'){
			data.province = ""	//省份
			data.city = that.data.city;						
		}else if(that.data.province==that.data.city){
			data.province =that.data.province;			//省份
			data.city = "";				//城市	
		}	else{
      data.province =that.data.province;			//省份
			data.city = that.data.city;			//城市	
    }
    data.searchName = that.data.searchName; //医生姓名以及疾病	
    data.goodat = that.data.goodat; //疾病	
    Service.screenDoctor(data).then((res) => {
      console.log("screenDoctor",res)
      if (res.code == 1) {
        that.setData({
          doctorList: res.data,
          showview: true
        })
      }
    })
  },
  //头部筛选 add by lq datetime 2020-4-21
  switchtab(e) {
    var that = this;
    if (that.data.switchIdx == e.currentTarget.dataset.id) {
      that.setData({
        switchIdx: 0,
      })
    } else {
      that.setData({
        switchIdx: e.currentTarget.dataset.id,
      })
    }
  },
  //省份选择 add by lq datetime 2020-4-21
  selectProvince: function (e) {
    var that = this;
    if (e.currentTarget.dataset.current == that.data.provinceTab) {
      that.setData({
        selectidx: e.currentTarget.dataset.current,
        selectidx2: that.data.cityTab,
        province: e.currentTarget.dataset.name
      })
    } else {
      that.setData({
        selectidx: e.currentTarget.dataset.current,
        selectidx2: -1,
        province: e.currentTarget.dataset.name
      })
    }
  },
  //城市选择 add by lq datetime 2020-4-21
  selectCity: function (e) {
    var that = this;
    that.setData({
      city: e.currentTarget.dataset.name == '全国' ? '' : e.currentTarget.dataset.name,
      cityTab: e.currentTarget.dataset.current,
      selectidx2: e.currentTarget.dataset.current,
      provinceTab: that.data.selectidx,
      switchIdx: 0,
      page: 0,
    })
    that.search('0')
  },
  //常见问题选择
  selectIssue(e) {
    var that = this;
    if (e.currentTarget.dataset.idx == 0) {
      that.setData({
        issueIndex: e.currentTarget.dataset.idx,
        goodat: e.currentTarget.dataset.name == "全部" ? '' : e.currentTarget.dataset.name,
        issueSearch: '常见问题',
        switchIdx: 0,
        selectIssue: true,
        page: 0,
      })
    } else {
      that.setData({
        issueIndex: e.currentTarget.dataset.idx,
        goodat: e.currentTarget.dataset.name == "全部" ? '' : e.currentTarget.dataset.name,
        issueSearch: that.data.issue[that.data.issueTab].child[e.currentTarget.dataset.idx].name,
        switchIdx: 0,
        selectIssue: true,
        page: 0,
      })
    }
    that.search('0')
  },
  ///服务类型选择
  selectCesel(e) {
    var that = this;
    if (e.currentTarget.dataset.cesel == that.data.cesel) {
      return;
    }
    that.setData({
      cesel: e.currentTarget.dataset.cesel,
      moneyArray: [{
          name: '1-50',
          key: '1-50'
        },
        {
          name: '50-100',
          key: '50-100'
        },
        {
          name: '100-200',
          key: '100-200'
        },
        {
          name: '200以上',
          key: '200'
        }
      ],
      moneyidx: 0
    })
    if (e.currentTarget.dataset.cesel == 18) {
      that.setData({
        moneyArray: [{
            name: '200-400',
            key: '200-400'
          },
          {
            name: '400-600',
            key: '400-600'
          },
          {
            name: '600-800',
            key: '600-800'
          },
          {
            name: '800以上',
            key: '800'
          }
        ],
        moneyidx: 0
      })
    } else if (e.currentTarget.dataset.cesel == 22) {
      that.setData({
        moneyArray: [{
            name: '500-1000',
            key: '500-1000'
          },
          {
            name: '1000-1500',
            key: '1000-1500'
          },
          {
            name: '1500-2000',
            key: '1500-2000'
          },
          {
            name: '2000以上',
            key: '2000'
          }
        ],
        moneyidx: 0
      })
    } else if (e.currentTarget.dataset.cesel == 19) {
      that.setData({
        moneyArray: [{
          name: '50-50',
          key: '50-50'
        }],
        moneyidx: 0
      })
    }
    that.setData({
      counsel1: e.currentTarget.dataset.cesel,
      price1: ''
    })
  },
  //价格区间选择
  selectMoney(e) {
    var that = this;
    if (e.currentTarget.dataset.name == '200以上') {
      that.setData({
        price1: '200',
      })
    } else {
      that.setData({
        price1: e.currentTarget.dataset.name,
      })
    }
    if (that.data.moneyidx == e.currentTarget.dataset.idx) {
      that.setData({
        moneyidx: 0,
        price1: ""
      })
    } else {
      that.setData({
        moneyidx: e.currentTarget.dataset.idx,
      })
    }
  },
  // 医生职称
  selectTitle(e) {
    var that = this;
    console.log(e.currentTarget.dataset.idx)
    if (that.data.titleidx == e.currentTarget.dataset.idx) {
      that.setData({
        titleidx: 0,
        title1: ''
      })
    } else {
      that.setData({
        titleidx: e.currentTarget.dataset.idx,
        title1: e.currentTarget.dataset.name
      })
    }
  },
  //完成
  end() {
    var that = this;
    that.setData({
      switchIdx: 0,
      selectSearch: true,
      counsel: that.data.counsel1,
      price: that.data.price1,
      title: that.data.title1,
      page: 0,
    })
    that.search('0')
  },
  //关闭筛选or打开筛选
  filtrateSelect: function () {
    if (this.data.filtrateSelect) {
      this.setData({
        filtrateSelect: false
      })
    } else {
      this.setData({
        filtrateSelect: true
      })
    }
  },
  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {
    let that = this;
    that.setData({
      scrollFlag: true,
      scrollFlag1: false,
      success: true
    })
    console.log(that.data.page, 'that.data.page')
    var door = that.data.door; //门诊参数
    var lcxl = that.data.lcxl; //临床心理
    var shxl = that.data.shxl; //社会心理
    var title = that.data.title; //职称
    var counsel = that.data.counsel; //	服务类型
    var price = that.data.price; //价格区间
    let data = {
      door: door,
      lcxl: lcxl,
      shxl: shxl,
      title: title,
      counsel: counsel,
      price: price,
      page: that.data.page+1,
    }
    //删选全部省或全部市
		if (that.data.province == '' || that.data.province == '热门城市'){
			data.province = ""	//省份
			data.city = that.data.city;						
		}else if(that.data.province==that.data.city){
			data.province =that.data.province;			//省份
			data.city = "";				//城市	
		}	else{
      data.province =that.data.province;			//省份
			data.city = that.data.city;			//城市	
    }
    data.searchName = that.data.searchName; //医生姓名以及疾病	
    data.goodat = that.data.goodat; //疾病	
    Service.screenDoctor(data).then((res) => {
      if (res.data.length <= 0) {
        that.setData({
          scrollFlag: false,
          scrollFlag1: true,
          success: true
        })
        var sTimeout = setTimeout(function () {
          that.setData({
            success: false
          })
        }, 2000)
      } else {
        if (res.data.length > 0) {
          var con = res.data
          var resu = that.data.doctorList;
          for (let i = 0; i < con.length; i++) {
            resu.push(con[i])
          }
          that.setData({
            page: Number(that.data.page) + 1,
            scrollFlag: true,
            scrollFlag1: false,
            success: 1,
            doctorList: resu
          })
        } else {
          that.setData({
            scrollFlag: false,
            scrollFlag1: true,
            success: true,
          })
        }
      }
      clearTimeout(sTimeout);
    })
  },
  inputSelect: function (e) {
    this.setData({
      searchName: e.detail.value,
      is_search: 1,
      page: 0
    })
    this.search('0');
  },
  //详情
  doctorInfo: function (e) {
    wx.showLoading({mask:true});
    wx.navigateTo({
      url: '/pages/docuterInfo/docuterInfo?t_unionid=' + e.currentTarget.dataset.unionid + '&t_unitid=' + e.currentTarget.dataset.unitid + '&t_openid=' + e.currentTarget.dataset.openid,
    })
    wx.hideLoading();
  },
  /**
   * 图片加载失败函数
   * @param {any} e 
   */
  binderrorimg(e) {
    let errorindex = e.currentTarget.dataset.errorindex;
    let up = "doctorList[" + errorindex + "].image";
    this.setData({
      [up]: '/images/doctor_img.png'
    })
  },
})