'use strict';
import TIM from 'tim-wx-sdk';
import COS from "cos-wx-sdk-v5";
const Util = require('./util.js');
/**正式IMSDKAppID */
let options = {
  SDKAppID: 1400103358 // 接入时需要将0替换为您的即时通信 IM 应用的 SDKAppID
}; 
/**测试IMSDK */
// let options = {
//   SDKAppID: 1400407697 // 接入时需要将0替换为您的即时通信 IM 应用的 SDKAppID
// };
// 创建 SDK 实例，`TIM.create()`方法对于同一个 `SDKAppID` 只会返回同一份实例
const tim = TIM.create(options); // SDK 实例通常用 tim 表示
const data = {
  sessionList: []
}
//-----------------------------事件绑定----------------------------
// 设置 SDK 日志输出级别，详细分级请参见 setLogLevel 接口的说明
/**
 * 0 普通级别，日志量较多，接入时建议使用
 * 1 release级别，SDK 输出关键信息，生产环境时建议使用
 * 2 告警级别，SDK 只输出告警和错误级别的日志
 * 3 错误级别，SDK 只输出错误级别的日志
 * 4 无日志级别，SDK 将不打印任何日志
 */
//tim.setLogLevel(0); // 普通级别，日志量较多，接入时建议使用
tim.setLogLevel(4); // release 级别，SDK 输出关键信息，生产环境时建议使用
// 注册 COS SDK 插件
tim.registerPlugin({
  'cos-wx-sdk': COS
});

// tim.on(TIM.EVENT.MESSAGE_RECEIVED, function (event) {
//   console.log("%c收到推送的单聊", "color:#04BE02", event)
//   // 收到推送的单聊、群聊、群提示、群系统通知的新消息，可通过遍历 event.data 获取消息列表数据并渲染到页面
//   // event.name - TIM.EVENT.MESSAGE_RECEIVED
//   // event.data - 存储 Message 对象的数组 - [Message]
// });

// tim.on(TIM.EVENT.MESSAGE_REVOKED, function (event) {
//   console.log("%c收到消息被撤回的通知", "color:#04BE02", event)
//   // 收到消息被撤回的通知。使用前需要将SDK版本升级至v2.4.0或以上。
//   // event.name - TIM.EVENT.MESSAGE_REVOKED
//   // event.data - 存储 Message 对象的数组 - [Message] - 每个 Message 对象的 isRevoked 属性值为 true
// });


function onConversationListUpdated(event) {
  console.log("%c收到会话列表更新通知", "color:#04BE02", event)
  data.sessionList = event.data;
  // 收到会话列表更新通知，可通过遍历 event.data 获取会话列表数据并渲染到页面
  // event.name - TIM.EVENT.CONVERSATION_LIST_UPDATED
  // event.data - 存储 Conversation 对象的数组 - [Conversation]
}
// tim.on(TIM.EVENT.MESSAGE_RECEIVED, onMessageReceived);
// function onMessageReceived(event) {
//   console.log("%c收到推送的单聊", "color:#04BE02", event)
//   // 收到推送的单聊、群聊、群提示、群系统通知的新消息，可通过遍历 event.data 获取消息列表数据并渲染到页面
//   // event.name - TIM.EVENT.MESSAGE_RECEIVED
//   // event.data - 存储 Message 对象的数组 - [Message]
// }
// tim.on(TIM.EVENT.GROUP_LIST_UPDATED, function (event) {
//   console.log("%c收到群组列表更新通知", "color:#04BE02", event)
//   // 收到群组列表更新通知，可通过遍历 event.data 获取群组列表数据并渲染到页面
//   // event.name - TIM.EVENT.GROUP_LIST_UPDATED
//   // event.data - 存储 Group 对象的数组 - [Group]
// });

// tim.on(TIM.EVENT.PROFILE_UPDATED, function (event) {
//   console.log("%c收到自己或好友的资料变更通知", "color:#04BE02", event)
//   // 收到自己或好友的资料变更通知
//   // event.name - TIM.EVENT.PROFILE_UPDATED
//   // event.data - 存储 Profile 对象的数组 - [Profile]
// });

// tim.on(TIM.EVENT.BLACKLIST_UPDATED, function (event) {
//   console.log("%c收到黑名单列表更新通知", "color:#04BE02", event)
//   // 收到黑名单列表更新通知
//   // event.name - TIM.EVENT.BLACKLIST_UPDATED
//   // event.data - 存储 userID 的数组 - [userID]
// });

tim.on(TIM.EVENT.ERROR,ERROR);
function  ERROR (event) {
  console.log("%c收到 SDK 发生错误通知", "color:#ff0000", event)
  // 收到 SDK 发生错误通知，可以获取错误码和错误信息
  // event.name - TIM.EVENT.ERROR
  // event.data.code - 错误码
  // event.data.message - 错误信息
}
// 监听事件，如：
tim.on(TIM.EVENT.SDK_READY, SDK_READY);
function SDK_READY(event) {
  console.log("%c收到离线消息和会话列表同步完毕通知", "color:#04BE02", event)
  getApp().globalData.isLogin = true;
  // 收到离线消息和会话列表同步完毕通知，接入侧可以调用 sendMessage 等需要鉴权的接口
  // event.name - TIM.EVENT.SDK_READY
}
tim.on(TIM.EVENT.SDK_NOT_READY, SDK_NOT_READY);
function SDK_NOT_READY (event) {
  console.log("%c收到 SDK 进入 not ready 状态通知", "color:#ff0000", event)
  getApp().globalData.isLogin = false;
  // 收到 SDK 进入 not ready 状态通知，此时 SDK 无法正常工作
  // event.name - TIM.EVENT.SDK_NOT_READY
}
tim.on(TIM.EVENT.KICKED_OUT,KICKED_OUT);
function KICKED_OUT(event){
  console.log("%c收到被踢下线通知", "color:#ff0000", event)
  wx.showModal({
    title: '提示',
    content: '收到被踢下线通知',
    showCancel:false,
    confirmColor:'#2684ff',
    confirmText:'重新登录',
    success (res) {
      if (res.confirm) {
        wx.showLoading({
          title: '正在登录',
          mask:true
        })
        getApp().getUserInfo(function (cb) {
          if (!Util.isEmpty(cb)) {
            wx.showToast({
              title: '登录成功',
            })
          }
        });
      }
      } 
  })
  // 收到被踢下线通知
  // event.name - TIM.EVENT.KICKED_OUT
  // event.data.type - 被踢下线的原因，例如 :
  //   - TIM.TYPES.KICKED_OUT_MULT_ACCOUNT 多实例登录被踢
  //   - TIM.TYPES.KICKED_OUT_MULT_DEVICE 多终端登录被踢
  //   - TIM.TYPES.KICKED_OUT_USERSIG_EXPIRED 签名过期被踢（v2.4.0起支持）。
}
tim.on(TIM.EVENT.NET_STATE_CHANGE,NET_STATE_CHANGE );
function NET_STATE_CHANGE(event) {
  console.log("%c网络状态发生改变", "color:#ff0000", event)
  wx.showToast({
    title: event.data.state,
  })
  NET_STATE_CHANGE
  // 网络状态发生改变（v2.5.0 起支持）。
  // event.name - TIM.EVENT.NET_STATE_CHANGE
  // event.data.state 当前网络状态，枚举值及说明如下：
  //   - TIM.TYPES.NET_STATE_CONNECTED - 已接入网络
  //   - TIM.TYPES.NET_STATE_CONNECTING - 连接中。很可能遇到网络抖动，SDK 在重试。接入侧可根据此状态提示“当前网络不稳定”或“连接中”
  //   - TIM.TYPES.NET_STATE_DISCONNECTED - 未接入网络。接入侧可根据此状态提示“当前网络不可用”。SDK 仍会继续重试，若用户网络恢复，SDK 会自动同步消息
}
/** 该tim.js中的方法 return 的都是promise对象*/
/**登录 -- https://cloud.tencent.com/document/product/269/37448 文档地址 常规集成（无UI库）>登录*/
/** 登录
 * add by LQ DateTime 2020-04-26 
 * @param {用户id} userID 
 * @param {用户密码} userSig 
 * service.js>getUserSig(user)
 */
function login(userID, userSig) {
  //登录成功后监听会话列表
  tim.on(TIM.EVENT.CONVERSATION_LIST_UPDATED, onConversationListUpdated);
  return tim.login({
    userID: userID,
    userSig: userSig
  })
}

/**发送消息 -- https://cloud.tencent.com/document/product/269/37448 文档地址 常规集成（无UI库）>消息收发  add by LQ DateTime 2020-04-26 */
/**
 * to	String	消息的接收方
 * conversationType	String	会话类型，取值TIM.TYPES.CONV_C2C或TIM.TYPES.CONV_GROUP
 * payload	Object	消息内容的容器 
 * offlinePushInfo Object 设置app推送 
 */
//发文本消息
function createTextMessage(options) {
  let message = tim.createTextMessage(options);
  let offlinePushInfo=this.offlinePushInfo(options);
  return tim.sendMessage(message,offlinePushInfo);
}
//发送图片消息
function createImageMessage(options) {
  // 2. 创建消息实例，接口返回的实例可以上屏
  let message = tim.createImageMessage(options);
  let offlinePushInfo=this.offlinePushInfo(options);
  // 3. 发送图片
  return tim.sendMessage(message,offlinePushInfo);
}
//发送音频消息
function createAudioMessage(options) {
  // 4. 创建消息实例，接口返回的实例可以上屏
  let message = tim.createAudioMessage(options);
  let offlinePushInfo=this.offlinePushInfo(options);
  // 5. 发送消息
  return tim.sendMessage(message,offlinePushInfo);
}
//发送自定义消息
function createCustomMessage(options) {
  let message = tim.createCustomMessage(options);
  let offlinePushInfo=this.offlinePushInfo(options);
  // 3. 发送消息
  return tim.sendMessage(message,offlinePushInfo);
}
/**
 * APP离线推送消息配置
 * @param {message}               消息体
 * @param {title}                 离线推送标题。该字段为 iOS 和 Android 共用
 * @param {description}           离线推送内容。该字段会覆盖消息实例的离线推送展示文本。若发送的是自定义消息，该 description 字段会覆盖 message.payload.description。如果 description 和 message.payload.description 字段都不填，接收方将收不到该自定义消息的离线推送
 * @param {androidOPPOChannelID}  离线推送设置 OPPO 手机 8.0 系统及以上的渠道 ID
 */
function offlinePushInfo(message){
  console.log("offlinePushInfo",message)
  let name=wx.getStorageSync('groupName')?wx.getStorageSync('groupName'):wx.getStorageSync('data').nickname;
  let description='';
  if(message.type=='TIMTextElem'){
    description=name+'：'+message.payload.text;
  }else if(message.type=='TIMImageElem'){
    description=name+'：[图片]';
  }else if(message.type=='TIMSoundElem'){
    description=name+'：[语音]';
  }else{
    message.payload.data = JSON.parse(message.payload.data)
    let type = message.payload.data.type;
    if(type=='report'){
      description=name+'：[检测报告]';
    }else if(type=='closeVideo'){
      description=name+'：[已挂断]';
    }else{
      description=name+'：[拒接接听]';
    }
  }
  return {
    // 如果接收方不在线，则消息将存入漫游，且进行离线推送（在接收方 App 退后台或者进程被 kill 的情况下）。接入侧可自定义离线推送的标题及内容
    offlinePushInfo: {
      title:'小懂健康',
      description: description, // 离线推送内容
      androidOPPOChannelID: 'Channel01' // 离线推送设置 OPPO 手机 8.0 系统及以上的渠道 ID
    }
  }
}
//发送关闭视频通话消息
function sendCloseVideocall(groupID) {
  let that=this;
  let message = {
    to: groupID,
    conversationType: TIM.TYPES.CONV_GROUP,
    payload: {
      data: JSON.stringify({
        type: 'closeVideo',
        content:'已挂断'
      }),
      description: "",
      extension: ""
    },
    type: "TIMCustomElem"
  }
  that.createCustomMessage(message).then((imResponse) => {
    console.log("%c报告消息发送成功", "color:#04BE02", imResponse)
  }).catch(imError => {
    console.error("发送失败", imError)
  });
}
//发送拒接视频通话消息
function sendRejectVideocall(groupID) {
  let that=this;
  let message = {
    to: groupID,
    conversationType: TIM.TYPES.CONV_GROUP,
    payload: {
      data: JSON.stringify({
        type: 'hangUpVideo',
        content:'拒接接听'
      }),
      description: "",
      extension: ""
    },
    type: "TIMCustomElem"
  }
  that.createCustomMessage(message).then((imResponse) => {
    console.log("%c报告消息发送成功", "color:#04BE02", imResponse)
  }).catch(imError => {
    console.error("发送失败", imError)
  });
}

/**撤回消息
 * 撤回单聊消息或者群聊消息。撤回成功后，消息对象的 isRevoked 属性值为 true。
 * https://imsdk-1252463788.file.myqcloud.com/IM_DOC/Web/Message.html?_ga=1.247845191.1158736621.1566791361 消息体实例文档
 * @param {消息体实例} message 
 */
function revokeMessage(message) {
  return tim.revokeMessage(message);
}
// 重发消息
function resendMessage(message) {
  return tim.resendMessage(message); // 传入需要重发的消息实例
}

/**获取某会话的消息列表
 * 分页拉取指定会话的消息列表的接口，当用户进入会话首次渲染消息列表或者用户“下拉查看更多消息”时，需调用该接口。 */
function getMessageList(options) {
  return tim.getMessageList(options);
}

/**将某会话下所有未读消息已读上报
 * 将某会话下的未读消息状态设置为已读，置为已读的消息不会计入到未读统计，当打开会话或切换会话时调用该接口。如果在打开/切换会话时，不调用该接口，则对应的消息会一直是未读的状态。
 * @param {会话ID} options.conversationID
 */
function setMessageRead(options) {
  return tim.setMessageRead({
    conversationID: options.conversationID
  });
}
/**获取会话列表
 * 获取会话列表的接口，该接口拉取最近的100条会话，当需要刷新会话列表时调用该接口。
 */
function getConversationList() {
  return tim.getConversationList();
}
/**获取会话资料
 * 获取会话资料的接口，当单击会话列表中的某个会话时，调用该接口获取会话的详细信息。
 */
function getConversationProfile(options) {
  return tim.getConversationProfile(options.conversationID)
}
/**获取群资料
 * 获取群资料的接口，当单击会话列表中的某个会话时，调用该接口获取群的详细信息。
 */
function getGroupProfile(options) {
  return tim.getGroupProfile(options)
}
/**
 * 个人资料 - Profile 实例
 */
function getMyProfile() {
  return tim.getMyProfile();
}
module.exports = {
  data: data,
  tim: tim,
  login: login, //登录
  createTextMessage: createTextMessage, //发送文本消息
  createImageMessage: createImageMessage, //发送图片消息
  createAudioMessage: createAudioMessage, //发送音频消息
  createCustomMessage: createCustomMessage, //自定义消息
  offlinePushInfo:offlinePushInfo ,//离线通知配置
  revokeMessage: revokeMessage, //消息撤回
  resendMessage: resendMessage, //消息重发
  getMessageList: getMessageList, //获取某会话的消息列表
  setMessageRead: setMessageRead, //将某会话下所有未读消息已读上报
  getConversationList: getConversationList, //获取会话列表
  getConversationProfile: getConversationProfile, //获取会话资料
  getGroupProfile: getGroupProfile, //获取群资料
  onConversationListUpdated: onConversationListUpdated, //监听会话列表实例
  getMyProfile: getMyProfile, //个人资料 - Profile 实例
  sendCloseVideocall:sendCloseVideocall, //发送挂断视频消息
  sendRejectVideocall:sendRejectVideocall,//拒接视频消息
  ERROR:ERROR,//错误信息
  SDK_NOT_READY:SDK_NOT_READY,//sdk错误通知
  SDK_READY:SDK_READY,
  KICKED_OUT:KICKED_OUT,//被踢下线通知
  NET_STATE_CHANGE:NET_STATE_CHANGE,//网络状态改变
}