const Service = require('../../utils/service.js');
const Util = require('../../utils/util.js');
Page({
  /**
   * 页面的初始数据
   */
  data: {
    noRecord: {
      winH: null,
    },
    isShow: false,
    record404: false,
    hidden: true,
    modelTel: 0,
    repeatClick: true,
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {
    let that = this;
    wx.getSystemInfoSync({
      success: (res) => {
        that.setData({
          ['noRecord.winH']: res.screenHeight
        })
      }
    })
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    this.getReportList();
  },
  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },
  /**
   * 量表续答
   * @param {*} e 
   */
  getScale(e) {
    let that = this;
    if (this.data.repeatClick) {
      this.setData({
        repeatClick: false
      })
      let item = e.currentTarget.dataset.item;
      let data = {
        record_id: item.measure_id_z,
        t_openid: item.t_openid,
        z_openid: item.z_openid,
        time: item.g_time,
        unitid: item.unitid,
        g_id: item.id,
        marketstatus: item.marketstatus,
      }
      if (e.currentTarget.dataset.item.inquiry == 2) { //1二维码，2聊天界面心理体检
        var monitor_url = '/pages/info/info?otype=1&inquiry=2&inquiry_id=' + item.inquiry_id;
      } else {
        var monitor_url = '/pages/info/info?otype=1&g_id=' + data.g_id;
      }
      wx.setStorageSync('weiLb', data);
      wx.navigateTo({
        url: monitor_url,
        success: function () {
          setTimeout(function () {
            that.setData({
              repeatClick: true
            })
          }, 500)
        }
      })
    }
  },
  /**
   * 量表查看
   * @param {*} e 
   */
  checkReport(e) {
    let that = this;
    var item = e.currentTarget.dataset.item;
    console.log("item", item);
    var phone = wx.getStorageSync('data').mobilephone;
    if (Util.isEmpty(phone)) {
      that.setData({
        modelTel: 1
      });
    } else {
      if (that.data.repeatClick) {
        that.setData({
          repeatClick: false
        })
        let data = {
          src: item.res_id
        };
        console.log(data);
        Service.isReport(data).then((res) => {
          // 查看列表权限
          if (res.data == '1') {
            that.setData({
              hidden: true
            })
            wx.navigateTo({
              url: '/packageB/webview/webview?id=' + item.res_id + '&lbname=' + item.measure_name + '&share=0&t_openid=' + 0,
              success: function () {
                setTimeout(function () {
                  that.setData({
                    repeatClick: true
                  })
                }, 500)
              }
            })
          } else {
            this.setData({
              hidden: false
            });
            wx.hideToast({
              aniamtion: true,
            })
          }
        })
      } else {
        this.setData({
          repeatClick: true
        })
      }
    }
  },
  /**
   * 量表列表
   */
  getReportList() {
    var that = this;
    let data = {};
    data.openid = wx.getStorageSync('user').openid;
    Service.getReportList(data).then((res) => {
      if (!res) {
        wx.showToast({
          title: '加载失败，请重新加载',
          icon: 'none',
          duration: 1000
        })
        return;
      }
      if (res[0].length == 0 && res[1].length == 0) {
        that.setData({
          record404: true
        })
      } else {
        that.structureDataUser(res[0]);
        var con = res[1];
        for (let i = 0; i < con.length; i++) {
          con[i].createtime = Util.timeMethod(con[i].createtime);
          con[i]['left'] = 0;
        }
        that.setData({
          [`userReport.haveDone`]: con,
          isShow: true,
        })
      }

    })
  },
  /**
   * 量表数据处理函数
   * @param {*} e 
   */
  structureDataUser(e) {
    let that = this;
    var json = [];
    for (let j in e) {
      if (e[j].measure_id_z != '') {
        var len = e[j].measure_id_z.split(',').length;
        e[j].time01 = Util.timeMethod(e[j].time);
        e[j].lb_num = len;
        json.push(e[j])
      } else {}
    }
    that.setData({
      ['userReport.notDone']: json
    })
  },
  /**
   * 滑动开始
   * @param {*} e 
   */
  startHandle(e) {
    let nearList = this.data.userReport.haveDone.map((item) => {
      item.left = 0;
      return item;
    });
    if (e.changedTouches.length == 1) {
      let startX = e.changedTouches[0].pageX
      this.setData({
        startX: startX,
      })
    }
  },
    /**
     * 左滑删除
     * @param {*} e 
     */
  moveHandle(e) {
    let startX = this.data.startX;
    var list = this.data.userReport.haveDone;
    let index = e.currentTarget.dataset.index;
    if (e.changedTouches.length == 1) {
      let moveX = e.changedTouches[0].pageX
      let disX = moveX - startX
      if (disX < -130) {
        disX = -130
      }
      if (disX > 0) {
        disX = 0
      }

      list[index].left = disX;
      this.setData({
        [`userReport.haveDone[${index}].left`]: disX
      })
    }
  },
  /**
   * 滑动结束
   * @param {*} e 
   */
  endHandle(e) {
    let startX = this.data.startX;
    var list = this.data.userReport.haveDone;
    let index = e.currentTarget.dataset.index;
    if (e.changedTouches.length == 1) {
      let endX = e.changedTouches[0].pageX;
      let disX = endX - startX
      if (disX <= -75) {
        disX = -130
      } else {
        disX = 0
      }
      if (disX > 0) {
        disX = 0
      }
      list[index].left = disX;
      this.setData({
        [`userReport.haveDone[${index}].left`]: disX
      })
    }
  },
  /**
   * 删除报告
   * @param {*} e 
   */
  delete:Util.debouce(function(e) {
    let that = this
    let id = e.currentTarget.dataset.delid;
    let index = e.currentTarget.dataset.index;
    let data = {
      openid: wx.getStorageSync('data').openid,
      id: id
    }
    var result = this.data.userReport.haveDone;
    Service.delReport(data).then(() => {
      result.splice(index, 1);
      wx.showToast({
        title: '删除成功',
        icon: 'success',
        duration: 2000
      })
      that.setData({
        ['userReport.haveDone']: result
      })
    })
  },1000,true),
  //绑定手机号
  goSetTel(e) {
    var user = wx.getStorageSync('user');
    var data = {
      openid: user.openid,
      encryptedData: e.detail.encryptedData,
      iv: e.detail.iv,
      session_key: user.session_key
    }
    Service.goSetTel(data).then((res) => {
      if (res.code == 1) {
        wx.showToast({
          title: '成功',
          icon: 'success',
          duration: 1000
        })
        var data = wx.getStorageSync('data');
        var resdata = JSON.parse(res.data)
        data.mobilephone = resdata.phoneNumber;
        wx.setStorageSync('data', data)
        this.setData({
          modelTel: 0
        });
        wx.hideToast();
      }
    })
    return;
  },
  //手机验证model关闭
  closeModelTel() {
    this.setData({
      modelTel: 0
    });
  },
  confirm: function () {
    this.setData({
      hidden: true,
      repeatClick: true
    });
  },
})