var Util = require('../../utils/util.js');
var Service = require('../../utils/service.js');
Page({

  /**
   * 页面的初始数据
   */
  data: {
    type: 1,
    deleteModal: true,
    start_time: '',
    userid: '',
    t_userInfo: {},
    t_openid: '',
    t_unitid: '',
    unionid: '',
    voice_price: '',
    image_price: '',
    iPhoneX: false,
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    var that = this;
    console.log('t_openid', options.t_openid)
    console.log('t_unitid', options.t_unitid)
    console.log('t_unionid', options.t_unionid)
    that.setData({
      t_openid: options.t_openid,
      t_unitid: options.t_unitid,
      t_unionid: options.t_unionid
    })
    var data = {};
    data.unitid = options.t_unitid;
    //获取医生服务信息
    Service.getDoctorDetail(data).then((res) => {
      if (res.code == 1) {
        var title;
        if (res.data.title == 1)
          title = '住院医师';
        if (res.data.title == 2)
          title = '主治医师';
        if (res.data.title == 3)
          title = '副主任医师';
        if (res.data.title == 4)
          title = '主任医师';
        if (res.data.title == 5)
          title = '国家心理治疗师';
        if (res.data.title == 6)
          title = '国家二级心理咨询师';
        if (res.data.title == 7)
          title = '国家三级心理咨询师';
        that.setData({
          t_userInfo: res.data,
          't_userInfo.title': title,
        })
      }
    })
  },
  selected(e) {
    let type = e.currentTarget.dataset.type;
    this.setData({
      type: type,
    })
  },
  select(e) {
    let num = e.currentTarget.dataset.num;
    this.setData({
      activeNum: num,
    })
  },
  goIntro() {
    var that = this;
    wx.navigateTo({
      url: '/pages/doctorIntro/doctorIntro?t_unionid=' + that.data.t_unionid + '&t_unitid=' + that.data.t_unitid + '&t_openid=' + that.data.t_openid,
    })
  },
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {},
  closeWin: function (e) {
    var win = e.target.dataset.id;
    if (win) {
      this.setData({
        deleteModal: true,
        btninfo: true
      })
    }
  },
  deleteModal: function () {
    this.setData({
      deleteModal: false
    })
  },
})